/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import ru.egisso.types.basic._2_0.TFio;

public class ErrorConverterUtil {
    private static final String SPACE = " ";
    private static final String COMMON_PATTERN = "\u0417\u0430\u043f\u0438\u0441\u044c \u2116\u043f/\u043f [%s]. \u041e\u0448\u0438\u0431\u043a\u0430: %s";
    private static final String VALUE_ERROR = "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 [%s] \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u0443 [%s]. \u0424\u0418\u041e: [%s]";
    private static final String VALUE = "Value ";
    private static final String RESPECT_TO = "respect to ";
    private static final String FOR_TYPE = " for type";
    private static final String CONTENT_ERROR = "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u0434\u043d\u043e \u0438\u0437 \u043f\u043e\u043b\u0435\u0439: [%s], \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c. \u0424\u0418\u041e: [%s]";
    private static final String ONE_OF = "One of ";
    private static final String IS_EXPECTED = " is expected";
    private static final String INVALID_ERROR = "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 [%s] \u043f\u043e\u043b\u044f \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e. \u0424\u0418\u041e: [%s]";
    private static final String THE_VALUE = "The value ";
    private static final String NOT_VALID = " is not valid";
    private static final String EMPTY = "\u041d\u0415\u0417\u0410\u0414\u0410\u041d\u041e";
    private static final List<String> FIO_FIELDS = Arrays.asList("forename", "patronymic", "surname");

    public static String translateError(Integer row, String error, TFio[] fio) {
        System.out.println(fio);
        String textMsg = error;
        String localizedFio = ErrorConverterUtil.getFio(Objects.isNull(fio) ? null : fio[0]);
        String localizedFioSecondary = Objects.nonNull(fio) && Objects.nonNull(fio[1]) ? ErrorConverterUtil.getFio(fio[1]) : null;
        try {
            if (error.contains(VALUE) && error.contains(RESPECT_TO)) {
                textMsg = ErrorConverterUtil.translateWrongValue(error, localizedFio);
            }
            if (error.contains(IS_EXPECTED) && error.contains(ONE_OF)) {
                textMsg = ErrorConverterUtil.translateWrongContent(error, localizedFio);
            }
            if (error.contains(THE_VALUE) && error.contains(NOT_VALID)) {
                textMsg = ErrorConverterUtil.translateNotValid(error, localizedFio);
            }
            textMsg = Objects.nonNull(localizedFioSecondary) ? textMsg + String.format(", [%s].", localizedFioSecondary) : textMsg + ".";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format(COMMON_PATTERN, row, textMsg);
    }

    private static String getFio(TFio fio) {
        if (Objects.isNull(fio)) {
            return EMPTY;
        }
        return (Objects.isNull(fio.getSurname()) || fio.getSurname().isEmpty() ? EMPTY : fio.getSurname()) + SPACE + (Objects.isNull(fio.getForename()) || fio.getForename().isEmpty() ? EMPTY : fio.getForename()) + SPACE + (Objects.isNull(fio.getPatronymic()) || fio.getPatronymic().isEmpty() ? EMPTY : fio.getPatronymic());
    }

    private static String translateWrongValue(String e, String fio) {
        String value = e.split(VALUE)[1].split(SPACE)[0];
        String pattern = e.split(RESPECT_TO)[1].split(FOR_TYPE)[0];
        return String.format(VALUE_ERROR, value, pattern, fio);
    }

    private static String translateWrongContent(String e, String fio) {
        String field = e.split(ONE_OF)[1].split(IS_EXPECTED)[0];
        field = field.replace("urn:", "");
        List<String> fields = Arrays.asList(field.split(","));
        field = fields.stream().map(f -> f.split(":")[1].replace("}", "").replace("'", "")).collect(Collectors.joining(","));
        return String.format(CONTENT_ERROR, field, fio);
    }

    private static String translateNotValid(String e, String fio) {
        String field = e.split(THE_VALUE)[1].split(NOT_VALID)[0];
        return String.format(INVALID_ERROR, field, fio);
    }
}

