/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import ru.pfrf.egisso.ExcelFileFilter;
import ru.pfrf.egisso.Presenter;
import ru.pfrf.egisso.View;

class ViewImpl
implements View {
    private Presenter presenter;
    private JFrame frame;
    private JComboBox docType = new JComboBox();
    private JButton start = new JButton("\u0417\u0430\u043f\u0443\u0441\u043a");
    private JButton stop = new JButton("\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
    private JPanel buttonPanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JLabel providerTip = new JLabel("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u0434 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445:");
    private JTextField provider = new JTextField(7);
    private JLabel filePath = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 Excel-\u0444\u0430\u0439\u043b:");
    private JTextField textSourceFilePath = new JTextField();
    private JButton selectFilePath = new JButton("...");
    private JLabel folderPath = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f XML \u0444\u0430\u0439\u043b\u0430:");
    private JTextField textDestinationFilePath = new JTextField();
    private JButton selectFolderPath = new JButton("...");
    private JPanel journalPanel = new JPanel();
    private JLabel lblJournal = new JLabel("\u0416\u0443\u0440\u043d\u0430\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438:");
    private JScrollPane scrollPane = new JScrollPane();
    private JTextArea journal = new JTextArea();

    ViewImpl() {
    }

    @Override
    public void setPresenter(Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void resetDocTypeToDefault() {
        this.docType.setSelectedIndex(0);
    }

    @Override
    public void setSourceFilePath(String path) {
        this.textSourceFilePath.setText(path);
    }

    @Override
    public void setDestinationFilePath(String path) {
        this.textDestinationFilePath.setText(path);
    }

    @Override
    public void display() {
        SwingUtilities.invokeLater(() -> {
            this.textDestinationFilePath.setColumns(10);
            this.frame = new JFrame("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044f Excel \u0444\u0430\u0439\u043b\u043e\u0432");
            this.frame.setDefaultCloseOperation(3);
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.columnWidths = new int[]{519, 0};
            gridBagLayout.rowHeights = new int[]{105, 360, 51, 0};
            gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
            gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
            this.frame.getContentPane().setLayout(gridBagLayout);
            GridBagConstraints gbcMainPanel = new GridBagConstraints();
            gbcMainPanel.fill = 1;
            gbcMainPanel.insets = new Insets(0, 0, 5, 0);
            gbcMainPanel.gridx = 0;
            gbcMainPanel.gridy = 0;
            this.frame.getContentPane().add((Component)this.mainPanel, gbcMainPanel);
            GridBagLayout gblMainPanel = new GridBagLayout();
            gblMainPanel.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
            gblMainPanel.rowHeights = new int[]{40, 0, 0, 0, 0, 0, 9, 0};
            gblMainPanel.columnWeights = new double[]{0.0, 0.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
            gblMainPanel.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
            this.mainPanel.setLayout(gblMainPanel);
            Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
            this.mainPanel.setBorder(emptyBorder);
            this.docType.addItem("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430...");
            this.docType.addItem("\u0420\u0435\u0435\u0441\u0442\u0440 \u043b\u0438\u0446, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0445 \u0441 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435\u043c \u0420\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u043f\u0440\u0430\u0432");
            this.docType.addItem("\u0420\u0435\u0435\u0441\u0442\u0440 \u043b\u0438\u0446, \u043f\u0440\u0438\u0437\u043d\u0430\u043d\u043d\u044b\u0445 \u043d\u0435\u0434\u0435\u0435\u0441\u043f\u043e\u0441\u043e\u0431\u043d\u044b\u043c\u0438 \u0438\u043b\u0438 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u044b\u0445 \u0432 \u0434\u0435\u0435\u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u0438");
            this.docType.addItem("\u0420\u0435\u0435\u0441\u0442\u0440 \u0437\u0430\u043a\u043e\u043d\u043d\u044b\u0445 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u0438\u0442\u0435\u043b\u0435\u0439");
            this.docType.addActionListener(e -> this.presenter.onDocTypeChange());
            GridBagConstraints docTypelblProvider = new GridBagConstraints();
            docTypelblProvider.anchor = 17;
            docTypelblProvider.gridwidth = 5;
            docTypelblProvider.insets = new Insets(0, 0, 5, 5);
            docTypelblProvider.fill = 1;
            docTypelblProvider.gridx = 0;
            docTypelblProvider.gridy = 0;
            this.mainPanel.add((Component)this.docType, docTypelblProvider);
            GridBagConstraints gbcLblProvider = new GridBagConstraints();
            gbcLblProvider.anchor = 17;
            gbcLblProvider.gridwidth = 2;
            gbcLblProvider.insets = new Insets(0, 0, 5, 5);
            gbcLblProvider.gridx = 1;
            gbcLblProvider.gridy = 2;
            this.mainPanel.add((Component)this.providerTip, gbcLblProvider);
            GridBagConstraints gbcTextProvider = new GridBagConstraints();
            gbcTextProvider.gridwidth = 1;
            gbcTextProvider.insets = new Insets(0, 0, 5, 5);
            gbcTextProvider.fill = 1;
            gbcTextProvider.gridx = 3;
            gbcTextProvider.gridy = 2;
            this.mainPanel.add((Component)this.provider, gbcTextProvider);
            this.provider.setPreferredSize(new Dimension(10, 25));
            GridBagConstraints gbcLblPath = new GridBagConstraints();
            gbcLblPath.anchor = 16;
            gbcLblPath.gridwidth = 4;
            gbcLblPath.insets = new Insets(0, 0, 5, 5);
            gbcLblPath.gridx = 1;
            gbcLblPath.gridy = 3;
            this.mainPanel.add((Component)this.filePath, gbcLblPath);
            GridBagConstraints gbcTextSourceFilePath = new GridBagConstraints();
            gbcTextSourceFilePath.gridwidth = 3;
            gbcTextSourceFilePath.insets = new Insets(0, 0, 5, 5);
            gbcTextSourceFilePath.fill = 1;
            gbcTextSourceFilePath.gridx = 1;
            gbcTextSourceFilePath.gridy = 4;
            this.mainPanel.add((Component)this.textSourceFilePath, gbcTextSourceFilePath);
            this.textSourceFilePath.setColumns(1);
            GridBagConstraints gbcBtnDestinationFilePath = new GridBagConstraints();
            gbcBtnDestinationFilePath.fill = 2;
            gbcBtnDestinationFilePath.insets = new Insets(0, 0, 5, 5);
            gbcBtnDestinationFilePath.gridx = 4;
            gbcBtnDestinationFilePath.gridy = 4;
            this.mainPanel.add((Component)this.selectFilePath, gbcBtnDestinationFilePath);
            this.selectFilePath.addActionListener(e -> this.presenter.onChooseFile());
            GridBagConstraints gbcLabel = new GridBagConstraints();
            gbcLabel.anchor = 17;
            gbcLabel.gridwidth = 4;
            gbcLabel.insets = new Insets(0, 0, 5, 5);
            gbcLabel.gridx = 1;
            gbcLabel.gridy = 5;
            this.mainPanel.add((Component)this.folderPath, gbcLabel);
            GridBagConstraints gbcTextDestinationFilePath = new GridBagConstraints();
            gbcTextDestinationFilePath.gridwidth = 3;
            gbcTextDestinationFilePath.insets = new Insets(0, 0, 5, 5);
            gbcTextDestinationFilePath.fill = 1;
            gbcTextDestinationFilePath.gridx = 1;
            gbcTextDestinationFilePath.gridy = 6;
            this.textDestinationFilePath.setColumns(1);
            this.mainPanel.add((Component)this.textDestinationFilePath, gbcTextDestinationFilePath);
            GridBagConstraints gbcBtnDestinationFilePath1 = new GridBagConstraints();
            gbcBtnDestinationFilePath1.fill = 2;
            gbcBtnDestinationFilePath1.insets = new Insets(0, 0, 5, 5);
            gbcBtnDestinationFilePath1.gridx = 4;
            gbcBtnDestinationFilePath1.gridy = 6;
            this.mainPanel.add((Component)this.selectFolderPath, gbcBtnDestinationFilePath1);
            this.selectFolderPath.addActionListener(e -> this.presenter.onChooseFolder());
            GridBagConstraints gbcJournalPanel = new GridBagConstraints();
            gbcJournalPanel.insets = new Insets(0, 0, 5, 0);
            gbcJournalPanel.fill = 1;
            gbcJournalPanel.gridx = 0;
            gbcJournalPanel.gridy = 1;
            this.frame.getContentPane().add((Component)this.journalPanel, gbcJournalPanel);
            GridBagLayout gblJournalPanel = new GridBagLayout();
            gblJournalPanel.columnWidths = new int[]{0, 0, 0, 0};
            gblJournalPanel.rowHeights = new int[]{17, 349, 0};
            gblJournalPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
            gblJournalPanel.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
            this.journalPanel.setLayout(gblJournalPanel);
            GridBagConstraints gbcLblJournal = new GridBagConstraints();
            gbcLblJournal.anchor = 17;
            gbcLblJournal.insets = new Insets(0, 0, 5, 5);
            gbcLblJournal.gridx = 1;
            gbcLblJournal.gridy = 0;
            this.journalPanel.add((Component)this.lblJournal, gbcLblJournal);
            GridBagConstraints gbcScrollPane = new GridBagConstraints();
            gbcScrollPane.insets = new Insets(0, 0, 0, 5);
            gbcScrollPane.fill = 1;
            gbcScrollPane.gridx = 1;
            gbcScrollPane.gridy = 1;
            this.journalPanel.add((Component)this.scrollPane, gbcScrollPane);
            this.journalPanel.setBorder(emptyBorder);
            this.journal.setEditable(false);
            this.scrollPane.setViewportView(this.journal);
            GridBagConstraints gbcButtonPanel = new GridBagConstraints();
            gbcButtonPanel.fill = 1;
            gbcButtonPanel.gridx = 0;
            gbcButtonPanel.gridy = 2;
            this.frame.getContentPane().add((Component)this.buttonPanel, gbcButtonPanel);
            this.start.addActionListener(e -> this.presenter.onStart());
            this.buttonPanel.add(this.start);
            this.stop.addActionListener(e -> this.presenter.onStop());
            this.buttonPanel.add(this.stop);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ViewImpl.this.presenter.onViewClose();
                }
            });
            this.frame.pack();
            this.frame.setVisible(true);
            this.presenter.onViewStart();
        });
    }

    @Override
    public File openFileDialog() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileFilter(new ExcelFileFilter());
        try {
            File dir = new File(".").getCanonicalFile();
            fileChooser.setCurrentDirectory(dir);
            fileChooser.showOpenDialog(this.frame);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return fileChooser.getSelectedFile();
    }

    @Override
    public String getProviderText() {
        return this.provider.getText();
    }

    @Override
    public File openFolderDialog() {
        JFileChooser fileChooser = new JFileChooser();
        try {
            File dir = new File(".").getCanonicalFile();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setCurrentDirectory(dir);
            fileChooser.showOpenDialog(this.frame);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return fileChooser.getSelectedFile();
    }

    @Override
    public int getDocType() {
        return this.docType.getSelectedIndex();
    }

    @Override
    public void appendToJournal(String msg) {
        SwingUtilities.invokeLater(() -> this.journal.append(msg));
    }

    @Override
    public void setJournal(String msg) {
        SwingUtilities.invokeLater(() -> this.journal.setText(msg));
    }

    @Override
    public String getDestinationFilePath() {
        return this.textDestinationFilePath.getText();
    }

    @Override
    public String getSourceFilePath() {
        return this.textSourceFilePath.getText();
    }

    @Override
    public void setStartEnabled(boolean enabled) {
        SwingUtilities.invokeLater(() -> this.start.setEnabled(enabled));
    }

    @Override
    public void setStopEnabled(boolean enabled) {
        SwingUtilities.invokeLater(() -> this.stop.setEnabled(enabled));
    }

    @Override
    public void onStop() {
        this.presenter.onStop();
    }

    @Override
    public void replaceLastJournalLine(String replacement) {
        SwingUtilities.invokeLater(() -> this.journal.setText(this.journal.getText().replaceFirst(".*\n*$", replacement + "\n")));
    }

    @Override
    public boolean showConfirmDialog(String msg, String title) {
        return JOptionPane.showConfirmDialog(this.frame, msg, title, 0, 3) == 0;
    }
}

