/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import com.fasterxml.uuid.Generators;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FileUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import ru.egisso.msg._10_25_i._2_0.Data;
import ru.egisso.types.basic._2_0.TFio;
import ru.egisso.types.basic._2_0.TGender;
import ru.egisso.types.basic._2_0.TPhysicalPersonSnilsOnly;
import ru.egisso.types.basic._2_0.TPhysicalPersonWithoutBirthPlace;
import ru.egisso.types.package_reg._2_0.TCreateRecord;
import ru.egisso.types.package_reg._2_0.TPackage;
import ru.egisso.types.registers._2_0.TDefinedDocument;
import ru.egisso.types.registers._2_0.TLegalPersonWithRole;
import ru.egisso.types.registers._2_0.TPersonFullDataWithRole;
import ru.egisso.types.registers._2_0.TPhysicalPersonFullDataWithRole;
import ru.gov.smev.artefacts.x.supplementary.commons._1_0.GenderType;
import ru.pfrf.egisso.Model;
import ru.pfrf.egisso.ModelImpl;
import ru.pfrf.egisso.Pair;
import ru.pfrf.egisso.Presenter;
import ru.pfrf.egisso.View;
import ru.pfrf.egisso.ViewImpl;
import ru.pfrf.egisso.utils.ErrorConverterUtil;

public class PresenterImpl
implements Presenter {
    public static final URL XSD_URL = PresenterImpl.class.getClassLoader().getResource("xsd/10.25.I-2.0.0.xsd");
    public static final String LOG_FILE = "excel-to-xml.log";
    private View view;
    private Model model;
    private DataFormatter formatter = new DataFormatter();
    private Workbook workbook;
    private File xmlFile;
    private Map<String, String> rlidDictEvents = new HashMap<String, String>();
    private Map<String, String> rlidDictDocTypes = new HashMap<String, String>();
    private Set<Pair<String, String>> rlidEvent2Doc = new HashSet<Pair<String, String>>();
    private Map<String, String> rlirpDictEvents = new HashMap<String, String>();
    private Map<String, String> rlirpDictDoc = new HashMap<String, String>();
    private Set<Pair<String, String>> rlirpEvent2Doc = new HashSet<Pair<String, String>>();
    private Map<String, String> rzpDictEvents = new HashMap<String, String>();
    private Map<String, String> rzpDictDoc = new HashMap<String, String>();
    private Set<Pair<String, String>> rzpEvent2Doc = new HashSet<Pair<String, String>>();
    private Map<String, String> commonDictGenders = new HashMap<String, String>();
    private Map<String, String> commonDictCitizenship = new HashMap<String, String>();
    private static ExecutorService executorService = Executors.newFixedThreadPool(2);
    private static Future<?> future;
    private Logger logger;
    private File logFile;
    Map<Object, Integer> objectMap = new HashMap<Object, Integer>();
    Boolean hasErrors = false;

    public PresenterImpl() {
        this.logger = this.initLogger();
    }

    public PresenterImpl(Model model, View view) {
        this();
        this.model = model;
        this.view = view;
    }

    private Logger initLogger() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        FileAppender<ILoggingEvent> fileAppender = new FileAppender<ILoggingEvent>();
        fileAppender.setContext(loggerContext);
        fileAppender.setName("timestamp");
        this.logFile = new File(LOG_FILE);
        if (this.logFile.exists()) {
            this.logFile.delete();
        }
        fileAppender.setFile(this.logFile.getAbsolutePath());
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(loggerContext);
        encoder.setPattern("%date{\"yyyy-MM-dd HH:mm:ss.SSS\"} %-5level [%30.30thread][%logger{35}] [%X{client_id}] [%X{request_id}] %message%n");
        encoder.start();
        fileAppender.setEncoder(encoder);
        fileAppender.start();
        Logger logger = loggerContext.getLogger("Main");
        logger.addAppender((Appender<ILoggingEvent>)fileAppender);
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            String error = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage() + "\n\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0432 \u0444\u0430\u0439\u043b\u0435: " + this.logFile.getAbsolutePath() + "\n\n";
            this.appendToLogAndView(error, e);
        });
        return logger;
    }

    public static void main(String ... args) {
        ViewImpl view = new ViewImpl();
        ModelImpl model = new ModelImpl();
        PresenterImpl presenter = new PresenterImpl(model, view);
        view.setPresenter(presenter);
        view.display();
    }

    @Override
    public void onChooseFile() {
        File file = this.view.openFileDialog();
        if (file != null && file.exists()) {
            this.view.setSourceFilePath(file.getPath());
        }
    }

    @Override
    public void onViewClose() {
        if (future != null && !future.isDone() && !future.isCancelled()) {
            if (this.view.showConfirmDialog("\u0412\u044b\u0439\u0442\u0438 \u0438\u0437 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b?", "\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044f \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430")) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    @Override
    public void onChooseFolder() {
        File file = this.view.openFolderDialog();
        if (file != null && file.exists() && file.isDirectory()) {
            this.view.setDestinationFilePath(file.getPath());
        }
    }

    private void fillRlirpDictionaries(Workbook workbook) {
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0421\u043e\u0431\u044b\u0442\u0438\u0435'...");
        this.fillDictionary(this.rlirpDictEvents, "\u0421\u043f\u0440.\u0421\u043e\u0431\u044b\u0442\u0438\u0435", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u041f\u043e\u043b'...");
        this.fillDictionary(this.commonDictGenders, "\u0421\u043f\u0440.\u041f\u043e\u043b", 0, 1, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e'...");
        this.fillDictionary(this.commonDictCitizenship, "\u0421\u043f\u0440.\u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442'...");
        this.fillDictionary(this.rlirpDictDoc, "\u0421\u043f\u0440.\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'...");
        this.fillLimits(this.rlirpEvent2Doc, "\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", 0, 2, workbook);
    }

    private String formatCellValue(Cell cell) {
        return this.formatter.formatCellValue(cell);
    }

    private void convertRlirp(Workbook workbook, Data data) {
        this.fillRlirpDictionaries(workbook);
        Sheet sheet = workbook.getSheet("\u0420\u0435\u0435\u0441\u0442\u0440");
        TPackage.Elements elements = data.getPackage().getElements();
        int rowCount = sheet.getLastRowNum() + 1;
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0440\u043e\u043a...");
        for (int i = 4; i < rowCount; ++i) {
            int recNum = i - 3;
            if (this.isCancelled()) {
                this.appendToLogAndView("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
                return;
            }
            Row row = sheet.getRow(i);
            if (this.formatCellValue(row.getCell(0)).isEmpty()) break;
            TPackage.Elements.CreateRecord createRecord = new TPackage.Elements.CreateRecord();
            createRecord.setRecUid(Generators.timeBasedGenerator().generate().toString());
            createRecord.setLegalEventUID(Generators.timeBasedGenerator().generate().toString());
            try {
                createRecord.setUpdateDate(this.exportXmlDate(new Date()));
                elements.getCreateRecord().add(createRecord);
                TCreateRecord.Rlirp rlirp = new TCreateRecord.Rlirp();
                createRecord.setRlirp(rlirp);
                createRecord.setCodeEventType(this.rlirpDictEvents.get(this.formatCellValue(row.getCell(1))));
                TPhysicalPersonFullDataWithRole parent = this.createPerson(row.getCell(2), row.getCell(3), row.getCell(4), row.getCell(5), row.getCell(6), row.getCell(7), row.getCell(8));
                rlirp.getPerson().add(parent);
                TDefinedDocument reasonDocument = new TDefinedDocument();
                reasonDocument.setCodeType(this.rlirpDictDoc.get(this.formatCellValue(row.getCell(9))));
                reasonDocument.setEffectiveDate(this.exportXmlDate(row.getCell(10)));
                reasonDocument.setDate(this.exportXmlDate(row.getCell(11)));
                String number = this.formatCellValue(row.getCell(12)).trim();
                reasonDocument.setNumber(number.isEmpty() ? null : number);
                String orgName = this.formatCellValue(row.getCell(13)).trim();
                reasonDocument.setIssuer(orgName.isEmpty() ? null : orgName);
                rlirp.setReasonDocument(reasonDocument);
                parent.setCodeRoleType(createRecord.getCodeEventType() + "01");
                TPhysicalPersonFullDataWithRole child = this.createPerson(row.getCell(14), row.getCell(15), row.getCell(16), row.getCell(17), row.getCell(18), row.getCell(19), row.getCell(20));
                child.setCodeRoleType(createRecord.getCodeEventType() + "02");
                rlirp.getPerson().add(child);
                TCreateRecord.Rlirp.Relation relation = new TCreateRecord.Rlirp.Relation();
                TPhysicalPersonSnilsOnly parentSnilsOnly = new TPhysicalPersonSnilsOnly();
                parentSnilsOnly.setSnils(parent.getSnils());
                relation.setParentSnils(parentSnilsOnly);
                TPhysicalPersonSnilsOnly childSnilsOnly = new TPhysicalPersonSnilsOnly();
                childSnilsOnly.setSnils(child.getSnils());
                relation.setChildSnils(childSnilsOnly);
                rlirp.getRelation().add(relation);
                String error = this.validateRlirpRecord(createRecord, recNum);
                if (error == null) continue;
                this.appendToLogAndView(error);
                continue;
            }
            catch (Exception e) {
                this.appendToLogAndView("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 " + recNum + "\n\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0432 \u0444\u0430\u0439\u043b\u0435: " + this.logFile.getAbsolutePath(), e);
            }
        }
        try {
            this.xmlFile = this.buildXmlFile();
            this.marshal(data, this.xmlFile);
        }
        catch (Exception e) {
            if (this.xmlFile.exists()) {
                this.xmlFile.delete();
            }
            String msg = "";
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                msg = e.getCause().getMessage();
            }
            this.appendToLogAndView("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 XML-\u0444\u0430\u0439\u043b\u0430: " + msg + "\n\n\u041f\u043e\u043b\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435: " + this.logFile.getAbsolutePath(), e);
        }
    }

    private File buildXmlFile() {
        SimpleDateFormat format = new SimpleDateFormat("ddMMyyyyHHmmss");
        this.xmlFile = new File(new File(this.view.getDestinationFilePath()), this.view.getProviderText() + "_" + format.format(new Date()) + ".xml");
        return this.xmlFile;
    }

    private void fillRlidDictionaries(Workbook workbook) {
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0421\u043e\u0431\u044b\u0442\u0438\u0435'...");
        this.fillDictionary(this.rlidDictEvents, "\u0421\u043f\u0440.\u0421\u043e\u0431\u044b\u0442\u0438\u0435", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442'...");
        this.fillDictionary(this.rlidDictDocTypes, "\u0421\u043f\u0440.\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u041f\u043e\u043b'...");
        this.fillDictionary(this.commonDictGenders, "\u0421\u043f\u0440.\u041f\u043e\u043b", 0, 1, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e'...");
        this.fillDictionary(this.commonDictCitizenship, "\u0421\u043f\u0440.\u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'...");
        this.fillLimits(this.rlidEvent2Doc, "\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", 0, 2, workbook);
    }

    private void fillLimits(Set<Pair<String, String>> pairs, String sheetName, int keyCellIndex, int valueCellIndex, Workbook workbook) {
        pairs.clear();
        Sheet sheet = workbook.getSheet(sheetName);
        Iterator it = sheet.iterator();
        it.next();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Cell keyCell = row.getCell(keyCellIndex);
            Cell valueCell = row.getCell(valueCellIndex);
            if (keyCell == null || valueCell == null) continue;
            pairs.add(new Pair<String, String>(this.formatCellValue(row.getCell(keyCellIndex)), this.formatCellValue(row.getCell(valueCellIndex))));
        }
        if (pairs.isEmpty()) {
            throw new RuntimeException("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a '" + sheetName + "' \u043d\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u043e\u043b\u043d\u0435\u043d");
        }
    }

    private void fillDictionary(Map<String, String> dict, String sheetName, int keyCellIndex, int valueCellIndex, Workbook workbook) {
        dict.clear();
        Sheet sheet = workbook.getSheet(sheetName);
        Iterator it = sheet.iterator();
        it.next();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Cell keyCell = row.getCell(keyCellIndex);
            Cell valueCell = row.getCell(valueCellIndex);
            if (keyCell == null || valueCell == null) continue;
            dict.put(this.formatCellValue(row.getCell(keyCellIndex)), this.formatCellValue(row.getCell(valueCellIndex)));
        }
        if (dict.isEmpty()) {
            throw new RuntimeException("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a '" + sheetName + "' \u043d\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u043e\u043b\u043d\u0435\u043d");
        }
    }

    private void convertRlid(Workbook workbook, Data data) {
        this.fillRlidDictionaries(workbook);
        Sheet sheet = workbook.getSheet("\u0420\u0435\u0435\u0441\u0442\u0440");
        TPackage.Elements elements = data.getPackage().getElements();
        int rowCount = sheet.getLastRowNum() + 1;
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0440\u043e\u043a...");
        for (int i = 4; i < rowCount; ++i) {
            int recNum = i - 3;
            if (this.isCancelled()) {
                this.appendToLogAndView("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
                return;
            }
            Row row = sheet.getRow(i);
            if (this.formatter.formatCellValue(row.getCell(0)).isEmpty()) break;
            TPackage.Elements.CreateRecord createRecord = new TPackage.Elements.CreateRecord();
            createRecord.setRecUid(Generators.timeBasedGenerator().generate().toString());
            createRecord.setLegalEventUID(Generators.timeBasedGenerator().generate().toString());
            try {
                createRecord.setUpdateDate(this.exportXmlDate(new Date()));
                elements.getCreateRecord().add(createRecord);
                TCreateRecord.Rlid rlid = new TCreateRecord.Rlid();
                createRecord.setRlid(rlid);
                createRecord.setCodeEventType(this.rlidDictEvents.get(this.formatCellValue(row.getCell(1))));
                TPhysicalPersonFullDataWithRole person = this.createPerson(row.getCell(2), row.getCell(3), row.getCell(4), row.getCell(5), row.getCell(6), row.getCell(7), row.getCell(8));
                rlid.setPerson(person);
                TDefinedDocument reasonDocument = new TDefinedDocument();
                reasonDocument.setCodeType(this.rlidDictDocTypes.get(this.formatCellValue(row.getCell(9))));
                reasonDocument.setEffectiveDate(this.exportXmlDate(row.getCell(10)));
                reasonDocument.setDate(this.exportXmlDate(row.getCell(11)));
                String series = this.formatCellValue(row.getCell(12)).trim();
                reasonDocument.setSeries(series.isEmpty() ? null : series);
                String number = this.formatCellValue(row.getCell(13)).trim();
                reasonDocument.setNumber(number.isEmpty() ? null : number);
                String orgName = this.formatCellValue(row.getCell(14)).trim();
                reasonDocument.setIssuer(orgName.isEmpty() ? null : orgName);
                rlid.setReasonDocument(reasonDocument);
                person.setCodeRoleType(createRecord.getCodeEventType() + "01");
                String error = this.validateRlidRecord(createRecord, recNum);
                if (error == null) continue;
                this.appendToLogAndView(error);
                continue;
            }
            catch (Exception e) {
                this.appendToLogAndView("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 " + recNum + "\n\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0432 \u0444\u0430\u0439\u043b\u0435: " + this.logFile.getAbsolutePath(), e);
            }
        }
        try {
            this.xmlFile = this.buildXmlFile();
            this.marshal(data, this.xmlFile);
        }
        catch (Exception e) {
            if (this.xmlFile.exists()) {
                this.xmlFile.delete();
            }
            String msg = "";
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                msg = e.getCause().getMessage();
            }
            this.appendToLogAndView("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 XML-\u0444\u0430\u0439\u043b\u0430: " + msg + "\n\n\u041f\u043e\u043b\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435: " + this.logFile.getAbsolutePath(), e);
        }
    }

    private void fillRzpDictionaries(Workbook workbook) {
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0421\u043e\u0431\u044b\u0442\u0438\u0435'...");
        this.fillDictionary(this.rzpDictEvents, "\u0421\u043f\u0440.\u0421\u043e\u0431\u044b\u0442\u0438\u0435", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442'...");
        this.fillDictionary(this.rzpDictDoc, "\u0421\u043f\u0440.\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u041f\u043e\u043b'...");
        this.fillDictionary(this.commonDictGenders, "\u0421\u043f\u0440.\u041f\u043e\u043b", 0, 1, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e'...");
        this.fillDictionary(this.commonDictCitizenship, "\u0421\u043f\u0440.\u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u0442\u0432\u043e", 1, 0, workbook);
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'...");
        this.fillLimits(this.rzpEvent2Doc, "\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", 0, 2, workbook);
    }

    private void convertRzp(Workbook workbook, Data data) {
        this.fillRzpDictionaries(workbook);
        Sheet sheet = workbook.getSheet("\u0420\u0435\u0435\u0441\u0442\u0440");
        TPackage.Elements elements = data.getPackage().getElements();
        int rowCount = sheet.getLastRowNum() + 1;
        this.appendToLogAndView("\u0427\u0442\u0435\u043d\u0438\u0435 \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0440\u043e\u043a...");
        for (int i = 4; i < rowCount; ++i) {
            int recNum = i - 3;
            if (this.isCancelled()) {
                this.appendToLogAndView("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
                return;
            }
            Row row = sheet.getRow(i);
            if (this.formatter.formatCellValue(row.getCell(0)).isEmpty()) break;
            TPackage.Elements.CreateRecord createRecord = new TPackage.Elements.CreateRecord();
            createRecord.setRecUid(Generators.timeBasedGenerator().generate().toString());
            createRecord.setLegalEventUID(Generators.timeBasedGenerator().generate().toString());
            try {
                createRecord.setUpdateDate(this.exportXmlDate(new Date()));
                elements.getCreateRecord().add(createRecord);
                TCreateRecord.Rzp rzp = new TCreateRecord.Rzp();
                createRecord.setRzp(rzp);
                createRecord.setCodeEventType(this.rzpDictEvents.get(this.formatCellValue(row.getCell(1))));
                TPersonFullDataWithRole tPerson = new TPersonFullDataWithRole();
                TPhysicalPersonFullDataWithRole parentWithPhysicalRole = null;
                String personType = this.formatCellValue(row.getCell(2));
                if (personType.equals("\u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e")) {
                    parentWithPhysicalRole = this.createPerson(row.getCell(3), row.getCell(4), row.getCell(5), row.getCell(6), row.getCell(7), row.getCell(8), row.getCell(9));
                    parentWithPhysicalRole.setCodeRoleType(createRecord.getCodeEventType() + "01");
                    tPerson.setPhysicalPerson(parentWithPhysicalRole);
                } else if (personType.equals("\u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e")) {
                    TPhysicalPersonWithoutBirthPlace parentLegal = this.createPhysicalPerson(row.getCell(3), row.getCell(4), row.getCell(5), row.getCell(6), row.getCell(7), row.getCell(8), row.getCell(9));
                    TLegalPersonWithRole person = this.createLegalPerson(row.getCell(10), row.getCell(11), row.getCell(12));
                    person.setCodeRoleType(createRecord.getCodeEventType() + "01");
                    person.setRepresentative(parentLegal);
                    tPerson.setLegalPerson(person);
                } else {
                    this.appendToLogAndView(String.format("\u0414\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u042e\u0440\u0438\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e \u0438\u043b\u0438 \u0424\u0438\u0437\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043b\u0438\u0446\u043e. \u0410\u0434\u0440\u0435\u0441 \u044f\u0447\u0435\u0439\u043a\u0438: \u0441\u0442\u0440\u043e\u043a\u0430 [%s], \u043a\u043e\u043b\u043e\u043d\u043a\u0430 [%s].", row.getCell(2).getAddress().getRow() + 1, row.getCell(2).getAddress().getColumn() + 1));
                }
                rzp.getPerson().add(tPerson);
                TDefinedDocument reasonDocument = new TDefinedDocument();
                reasonDocument.setCodeType(this.rzpDictDoc.get(this.formatCellValue(row.getCell(13))));
                reasonDocument.setEffectiveDate(this.exportXmlDate(row.getCell(14)));
                reasonDocument.setValidityEndDate(this.exportXmlDate(row.getCell(15)));
                reasonDocument.setDate(this.exportXmlDate(row.getCell(16)));
                String series = this.formatCellValue(row.getCell(17)).trim();
                reasonDocument.setSeries(series.isEmpty() ? null : series);
                String number = this.formatCellValue(row.getCell(18)).trim();
                reasonDocument.setNumber(number.isEmpty() ? null : number);
                String orgName = this.formatCellValue(row.getCell(19)).trim();
                reasonDocument.setIssuer(orgName.isEmpty() ? null : orgName);
                rzp.setReasonDocument(reasonDocument);
                TPersonFullDataWithRole child = new TPersonFullDataWithRole();
                TPhysicalPersonFullDataWithRole childWithRole = this.createPerson(row.getCell(20), row.getCell(21), row.getCell(22), row.getCell(23), row.getCell(24), row.getCell(25), row.getCell(26));
                childWithRole.setCodeRoleType(createRecord.getCodeEventType() + "02");
                child.setPhysicalPerson(childWithRole);
                rzp.getPerson().add(child);
                TCreateRecord.Rzp.Relation relation = new TCreateRecord.Rzp.Relation();
                TPhysicalPersonSnilsOnly representativeSnils = new TPhysicalPersonSnilsOnly();
                representativeSnils.setSnils(tPerson.getPhysicalPerson() != null ? tPerson.getPhysicalPerson().getSnils() : tPerson.getLegalPerson().getRepresentative().getSnils());
                relation.setRepresentativePersonSnils(representativeSnils);
                TPhysicalPersonSnilsOnly representedSnils = new TPhysicalPersonSnilsOnly();
                representedSnils.setSnils(child.getPhysicalPerson().getSnils());
                relation.setRepsesentedPersonSnils(representedSnils);
                rzp.getRelation().add(relation);
                String error = this.validateRzpRecord(createRecord, recNum);
                if (error == null) continue;
                this.appendToLogAndView(error);
                continue;
            }
            catch (Exception e) {
                this.appendToLogAndView("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 " + recNum + "\n\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0432 \u0444\u0430\u0439\u043b\u0435: " + this.logFile.getAbsolutePath(), e);
            }
        }
        try {
            this.xmlFile = this.buildXmlFile();
            this.marshal(data, this.xmlFile);
        }
        catch (Exception e) {
            if (this.xmlFile.exists()) {
                this.xmlFile.delete();
            }
            String msg = "";
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                msg = e.getCause().getMessage();
            }
            this.appendToLogAndView("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 XML-\u0444\u0430\u0439\u043b\u0430: " + msg + "\n\n\u041f\u043e\u043b\u043d\u043e\u0435 \u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435: " + this.logFile.getAbsolutePath(), e);
        }
    }

    private String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private void appendToLogAndView(String viewMsg) {
        this.logger.info(viewMsg);
        viewMsg = viewMsg + "\n";
        if (viewMsg != null && !viewMsg.isEmpty()) {
            this.view.appendToJournal(viewMsg);
        }
    }

    public void appendToLogAndView(String viewMsg, Throwable e) {
        this.logger.error(viewMsg, e);
        viewMsg = viewMsg + "\n";
        if (viewMsg != null && !viewMsg.isEmpty()) {
            this.view.appendToJournal(viewMsg);
        }
    }

    @Override
    public Workbook createWorkbook(FileInputStream file) throws IOException {
        return new XSSFWorkbook(file);
    }

    private boolean isCancelled() {
        return future != null && future.isCancelled();
    }

    @Override
    public Future getFuture() {
        return future;
    }

    @Override
    public void onStart() {
        if (!this.validateView()) {
            return;
        }
        this.view.setJournal("");
        future = executorService.submit(() -> {
            FileInputStream file;
            this.appendToLogAndView("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0447\u0430\u0442\u043e " + LocalDateTime.now().toString());
            int type = this.view.getDocType();
            this.appendToLogAndView(String.format("\u0418\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0444\u0430\u0439\u043b: [%s]", this.view.getSourceFilePath()));
            Data data = new Data();
            TPackage tPackage = new TPackage();
            data.setPackage(tPackage);
            tPackage.setPackageId(Generators.timeBasedGenerator().generate().toString());
            TPackage.Elements elements = new TPackage.Elements();
            tPackage.setElements(elements);
            try {
                file = new FileInputStream(new File(this.view.getSourceFilePath()));
            }
            catch (FileNotFoundException e) {
                this.appendToLogAndView("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043a\u0440\u044b\u0442\u044c Excel-\u0444\u0430\u0439\u043b", e);
                return;
            }
            try {
                this.appendToLogAndView("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 Excel-\u0444\u0430\u0439\u043b\u0430...");
                this.workbook = this.createWorkbook(file);
            }
            catch (IOException e) {
                this.appendToLogAndView("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c Excel-\u0444\u0430\u0439\u043b", e);
                return;
            }
            switch (type) {
                case 1: {
                    this.convertRlirp(this.workbook, data);
                    break;
                }
                case 2: {
                    this.convertRlid(this.workbook, data);
                    break;
                }
                case 3: {
                    this.convertRzp(this.workbook, data);
                    break;
                }
                default: {
                    this.view.setJournal("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                    return;
                }
            }
        });
        executorService.execute(() -> {
            try {
                future.get();
            }
            catch (InterruptedException | CancellationException e) {
                this.logger.error("", e);
            }
            catch (Exception e) {
                String error = "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage() + "\n\u041f\u043e\u0434\u0440\u043e\u0431\u043d\u043e\u0441\u0442\u0438 \u0432 \u0444\u0430\u0439\u043b\u0435: " + this.logFile.getAbsolutePath() + "\n\n";
                this.appendToLogAndView(error, e);
            }
        });
    }

    @Override
    public void setModel(Model model) {
        this.model = model;
    }

    @Override
    public void setView(View view) {
        this.view = view;
    }

    @Override
    public void onViewStart() {
    }

    @Override
    public void onDocTypeChange() {
    }

    @Override
    public void onStop() {
        if (future != null) {
            future.cancel(true);
        }
    }

    @Override
    public File getXmlFile() {
        return this.xmlFile;
    }

    private String validateRlirpRecord(TPackage.Elements.CreateRecord createRecord, int row) throws JAXBException, SAXException {
        TCreateRecord.Rlirp rlirp = createRecord.getRlirp();
        String error = null;
        if (createRecord.getCodeEventType() == null || rlirp.getReasonDocument().getCodeType() == null) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432 \u043f\u043e\u043b\u0435 '\u0412\u0438\u0434 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0432\u0438\u0434\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'";
        }
        if (!this.rlirpEvent2Doc.contains(new Pair<String, String>(createRecord.getCodeEventType(), rlirp.getReasonDocument().getCodeType()))) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432 \u043f\u043e\u043b\u0435 '\u0412\u0438\u0434 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0432\u0438\u0434\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'";
        }
        for (TPhysicalPersonFullDataWithRole person : rlirp.getPerson()) {
            if (person.getBirthDate() == null || !person.getBirthDate().toGregorianCalendar().after(createRecord.getUpdateDate().toGregorianCalendar())) continue;
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0432 \u043f\u043e\u043b\u0435 '\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f' \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439";
        }
        if (rlirp.getReasonDocument().getDate() != null && rlirp.getReasonDocument().getDate().toGregorianCalendar().after(createRecord.getUpdateDate().toGregorianCalendar())) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0432 \u043f\u043e\u043b\u0435 '\u0414\u0430\u0442\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439";
        }
        return error;
    }

    private String validateRlidRecord(TPackage.Elements.CreateRecord createRecord, int row) throws JAXBException, SAXException {
        int result;
        TCreateRecord.Rlid rlid = createRecord.getRlid();
        String error = null;
        if (createRecord.getCodeEventType() == null || rlid.getReasonDocument().getCodeType() == null) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432 \u043f\u043e\u043b\u0435 '\u0412\u0438\u0434 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0432\u0438\u0434\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'";
        }
        if (!this.rlidEvent2Doc.contains(new Pair<String, String>(createRecord.getCodeEventType(), rlid.getReasonDocument().getCodeType()))) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432 \u043f\u043e\u043b\u0435 '\u0412\u0438\u0434 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0432\u0438\u0434\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'";
        }
        if (rlid.getPerson().getBirthDate() != null && (result = rlid.getPerson().getBirthDate().toGregorianCalendar().compareTo(createRecord.getUpdateDate().toGregorianCalendar())) > 0) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0432 \u043f\u043e\u043b\u0435 '\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f' \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439";
        }
        if (rlid.getReasonDocument().getEffectiveDate() != null && (result = rlid.getReasonDocument().getEffectiveDate().toGregorianCalendar().compareTo(createRecord.getUpdateDate().toGregorianCalendar())) > 0) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0432 \u043f\u043e\u043b\u0435 '\u0414\u0430\u0442\u0430 \u0432\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u044f \u0432 \u0441\u0438\u043b\u0443 (\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0434\u0435\u0435\u0441\u043f\u043e\u0441\u043e\u0431\u043d\u043e\u0441\u0442\u0438)' \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439";
        }
        if (rlid.getReasonDocument().getDate() != null && (result = rlid.getReasonDocument().getDate().toGregorianCalendar().compareTo(createRecord.getUpdateDate().toGregorianCalendar())) > 0) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0432 \u043f\u043e\u043b\u0435 '\u0414\u0430\u0442\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439";
        }
        return error;
    }

    private String validateRzpRecord(TPackage.Elements.CreateRecord createRecord, int row) throws JAXBException, SAXException {
        TCreateRecord.Rzp rzp = createRecord.getRzp();
        if (createRecord.getCodeEventType() == null || rzp.getReasonDocument().getCodeType() == null) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432 \u043f\u043e\u043b\u0435 '\u0412\u0438\u0434 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0432\u0438\u0434\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'";
        }
        if (!this.rzpEvent2Doc.contains(new Pair<String, String>(createRecord.getCodeEventType(), rzp.getReasonDocument().getCodeType()))) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432 \u043f\u043e\u043b\u0435 '\u0412\u0438\u0434 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0432\u0438\u0434\u0443 \u0441\u043e\u0431\u044b\u0442\u0438\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 '\u0421\u043f\u0440.\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u044f\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430'";
        }
        for (TPersonFullDataWithRole person : rzp.getPerson()) {
            if (person.getPhysicalPerson() == null || person.getPhysicalPerson().getBirthDate() == null || !person.getPhysicalPerson().getBirthDate().toGregorianCalendar().after(createRecord.getUpdateDate().toGregorianCalendar())) continue;
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0432 \u043f\u043e\u043b\u0435 '\u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f' \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439";
        }
        if (rzp.getReasonDocument().getEffectiveDate() != null && rzp.getReasonDocument().getEffectiveDate().toGregorianCalendar().after(createRecord.getUpdateDate().toGregorianCalendar())) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0432 \u043f\u043e\u043b\u0435 '\u0414\u0430\u0442\u0430 \u0432\u0441\u0442\u0443\u043f\u043b\u0435\u043d\u0438\u044f \u0432 \u0441\u0438\u043b\u0443 (\u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430)' \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439";
        }
        if (rzp.getReasonDocument().getDate() != null && rzp.getReasonDocument().getDate().toGregorianCalendar().after(createRecord.getUpdateDate().toGregorianCalendar())) {
            return "\u0421\u0442\u0440\u043e\u043a\u0430 " + row + ": \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u0442\u044b \u0432 \u043f\u043e\u043b\u0435 '\u0414\u0430\u0442\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430' \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0439";
        }
        return null;
    }

    @Override
    public Data unmarshal() throws JAXBException, IOException {
        String xml = FileUtils.readFileToString(this.xmlFile, StandardCharsets.UTF_8);
        Unmarshaller unmarshaller = JAXBContext.newInstance(Data.class).createUnmarshaller();
        return (Data)unmarshaller.unmarshal(new StringReader(xml));
    }

    private void marshal(Data data, File xmlFile) throws JAXBException, SAXException {
        this.hasErrors = false;
        final HashSet errors = new HashSet();
        final Set[] errorWithRows = new Set[]{new HashSet()};
        this.appendToLogAndView(String.format("\u041a\u043e\u043d\u0435\u0447\u043d\u044b\u0439 \u0444\u0430\u0439\u043b: [%s]", xmlFile.getAbsolutePath()));
        this.appendToLogAndView("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 XML-\u0444\u0430\u0439\u043b\u0430...");
        this.objectMap = new HashMap<Object, Integer>();
        JAXBContext jaxbContext = JAXBContext.newInstance(Data.class);
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", true);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(XSD_URL);
        marshaller.setSchema(schema);
        final int createRecords = data.getPackage().getElements().getCreateRecord().size();
        marshaller.setEventHandler(new ValidationEventHandler(){

            @Override
            public boolean handleEvent(ValidationEvent event) {
                Integer row;
                String error;
                if (event.getSeverity() >= 1) {
                    PresenterImpl.this.hasErrors = true;
                }
                if (errors.add(error = ErrorConverterUtil.translateError(row = Integer.valueOf(PresenterImpl.this.objectMap.get(event.getLocator().getObject()) + 1), event.getMessage(), null))) {
                    errorWithRows[0].add(new ErrorWithRow(row, event));
                }
                return true;
            }
        });
        marshaller.setListener(new Marshaller.Listener(){
            int i = 0;

            @Override
            public void beforeMarshal(Object source) {
                PresenterImpl.this.objectMap.put(source, this.i);
            }

            @Override
            public void afterMarshal(Object source) {
                if (PresenterImpl.this.isCancelled()) {
                    throw new RuntimeException("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430");
                }
                if (source instanceof TPackage.Elements.CreateRecord) {
                    errorWithRows[0].forEach(e -> {
                        TFio[] fio = new TFio[2];
                        PresenterImpl.this.objectMap.keySet().forEach(k -> {
                            if (PresenterImpl.this.objectMap.get(k).equals(e.row - 1) && k instanceof TFio) {
                                if (Objects.isNull(fio[0])) {
                                    fio[0] = (TFio)k;
                                } else {
                                    fio[1] = (TFio)k;
                                }
                            }
                        });
                        String error = ErrorConverterUtil.translateError(e.row, e.ev.getMessage(), fio);
                        PresenterImpl.this.appendToLogAndView(error);
                    });
                    errorWithRows[0] = new HashSet();
                    String msg = "\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e " + ++this.i + " \u0441\u0442\u0440\u043e\u043a \u0438\u0437 " + createRecords;
                    PresenterImpl.this.appendToLogAndView(msg);
                }
                super.afterMarshal(source);
            }
        });
        marshaller.marshal((Object)data, xmlFile);
        if (this.hasErrors.booleanValue()) {
            throw new MarshalException(new MarshalException("\u0424\u0430\u0439\u043b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d \u0438\u0437-\u0437\u0430 \u043e\u0448\u0438\u0431\u043e\u043a \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u0435\u0439."));
        }
        String successMsg = "XML-\u0444\u0430\u0439\u043b \u0441\u043e\u0437\u0434\u0430\u043d: " + xmlFile.getAbsolutePath();
        this.appendToLogAndView(successMsg);
    }

    private XMLGregorianCalendar exportXmlDate(Date date) throws DatatypeConfigurationException {
        return this.exportXmlDate(date, false);
    }

    private XMLGregorianCalendar exportXmlDate(Date date, boolean withoutTimeZone) throws DatatypeConfigurationException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        XMLGregorianCalendar xmlGregCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        xmlGregCal.setMillisecond(Integer.MIN_VALUE);
        if (withoutTimeZone) {
            xmlGregCal.setTimezone(Integer.MIN_VALUE);
        }
        return xmlGregCal;
    }

    private XMLGregorianCalendar exportXmlDate(Cell cell) throws DatatypeConfigurationException {
        Date date;
        if (cell == null) {
            return null;
        }
        if (1 == cell.getCellType() && cell.getStringCellValue().isEmpty()) {
            return null;
        }
        if (cell.getCellType() == 0) {
            date = cell.getDateCellValue();
        } else {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            try {
                date = format.parse(this.formatCellValue(cell));
            }
            catch (ParseException e) {
                return null;
            }
        }
        return this.exportXmlDate(date, true);
    }

    private TPhysicalPersonWithoutBirthPlace createPhysicalPerson(Cell ... cells) throws Exception {
        TPhysicalPersonWithoutBirthPlace person = new TPhysicalPersonWithoutBirthPlace();
        person.setSnils(this.formatter.formatCellValue(cells[0]));
        person.setBirthDate(this.exportXmlDate(cells[1]));
        String lastName = this.formatCellValue(cells[2]).trim();
        String firstName = this.formatCellValue(cells[3]).trim();
        String middleName = this.formatCellValue(cells[4]).trim();
        TFio fio = new TFio();
        fio.setSurname(lastName.isEmpty() ? null : lastName);
        fio.setPatronymic(middleName.isEmpty() ? null : middleName);
        fio.setForename(firstName.isEmpty() ? null : firstName);
        person.setFio(fio);
        String gender = this.commonDictGenders.get(this.formatCellValue(cells[5]));
        if (GenderType.MALE.value().equals(gender)) {
            person.setGender(TGender.M);
        } else if (GenderType.FEMALE.value().equals(gender)) {
            person.setGender(TGender.F);
        } else {
            String msg = String.format("\u041e\u0448\u0438\u0431\u043a\u0430: \u041f\u043e\u043b \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u041c \u0438\u043b\u0438 \u0416. \u0410\u0434\u0440\u0435\u0441 \u044f\u0447\u0435\u0439\u043a\u0438: \u0441\u0442\u0440\u043e\u043a\u0430 [%s], \u043a\u043e\u043b\u043e\u043d\u043a\u0430 [%s].", cells[5].getAddress().getRow() + 1, cells[5].getAddress().getColumn() + 1);
            this.appendToLogAndView(msg);
        }
        person.setCitizenshipCode(this.commonDictCitizenship.get(this.formatter.formatCellValue(cells[6]).trim()));
        return person;
    }

    private TLegalPersonWithRole createLegalPerson(Cell ... cells) {
        TLegalPersonWithRole person = new TLegalPersonWithRole();
        person.setInn(this.formatCellValue(cells[0]));
        person.setOgrn(this.formatCellValue(cells[1]));
        String name = this.formatCellValue(cells[2]).trim();
        person.setName(name.isEmpty() ? null : name);
        return person;
    }

    private TPhysicalPersonFullDataWithRole createPerson(Cell ... cells) throws Exception {
        TPhysicalPersonFullDataWithRole person = new TPhysicalPersonFullDataWithRole();
        person.setSnils(this.formatCellValue(cells[0]));
        person.setBirthDate(this.exportXmlDate(cells[1]));
        String lastName = this.formatCellValue(cells[2]).trim();
        String firstName = this.formatCellValue(cells[3]).trim();
        String middleName = this.formatCellValue(cells[4]).trim();
        TFio fio = new TFio();
        fio.setSurname(lastName.isEmpty() ? null : lastName);
        fio.setPatronymic(middleName.isEmpty() ? null : middleName);
        fio.setForename(firstName.isEmpty() ? null : firstName);
        person.setFio(fio);
        String gender = this.commonDictGenders.get(this.formatCellValue(cells[5]));
        if (GenderType.MALE.value().equals(gender)) {
            person.setGender(TGender.M);
        } else if (GenderType.FEMALE.value().equals(gender)) {
            person.setGender(TGender.F);
        } else {
            String msg = String.format("\u041e\u0448\u0438\u0431\u043a\u0430: \u041f\u043e\u043b \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u041c \u0438\u043b\u0438 \u0416. \u0410\u0434\u0440\u0435\u0441 \u044f\u0447\u0435\u0439\u043a\u0438: \u0441\u0442\u0440\u043e\u043a\u0430 [%s], \u043a\u043e\u043b\u043e\u043d\u043a\u0430 [%s].", cells[5].getAddress().getRow() + 1, cells[5].getAddress().getColumn() + 1);
            this.appendToLogAndView(msg);
        }
        person.setCitizenshipCode(this.commonDictCitizenship.get(this.formatter.formatCellValue(cells[6]).trim()));
        return person;
    }

    private boolean validateView() {
        if (this.view.getDocType() == 0) {
            this.view.setJournal("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
            return false;
        }
        if (!this.view.getProviderText().matches(".{4}\\..{6}")) {
            this.view.setJournal("\u041a\u043e\u0434 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 PPPP.PPPPPP");
            return false;
        }
        if (this.view.getSourceFilePath().isEmpty() || !new File(this.view.getSourceFilePath()).exists()) {
            this.view.setJournal("Excel-\u0444\u0430\u0439\u043b \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
            return false;
        }
        if (this.view.getDestinationFilePath().isEmpty() || !new File(this.view.getDestinationFilePath()).exists()) {
            this.view.setJournal("\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
            return false;
        }
        this.view.setJournal("");
        return true;
    }

    class ErrorWithRow {
        int row;
        ValidationEvent ev;

        ErrorWithRow(int row, ValidationEvent ev) {
            this.ev = ev;
            this.row = row;
        }
    }
}

