/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso;

import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static void copyRow(XSSFWorkbook workbook, String sheetName, int rowsToCopy) {
        int lastRowNum = ExcelUtils.getLastRowIndex(workbook, sheetName);
        XSSFSheet sheet = workbook.getSheet(sheetName);
        for (int i = 0; i < rowsToCopy; ++i) {
            sheet.copyRows(lastRowNum, lastRowNum, lastRowNum + 1, new CellCopyPolicy());
            ++lastRowNum;
        }
    }

    public static void copyRow(XSSFWorkbook workbook, String sheetName, int rowsToCopy, String outFile) throws IOException {
        int lastRowNum = ExcelUtils.getLastRowIndex(workbook, sheetName);
        XSSFSheet sheet = workbook.getSheet(sheetName);
        for (int i = 0; i < rowsToCopy; ++i) {
            sheet.copyRows(lastRowNum, lastRowNum, lastRowNum + 1, new CellCopyPolicy());
            ++lastRowNum;
        }
        FileOutputStream out = new FileOutputStream(outFile);
        workbook.write(out);
        out.close();
    }

    public static int getLastRowIndex(Workbook workbook, String sheetName) {
        int lastRowNum;
        Sheet sheet = workbook.getSheet(sheetName);
        for (lastRowNum = sheet.getLastRowNum(); lastRowNum >= 0; --lastRowNum) {
            Row row = sheet.getRow(lastRowNum);
            if (row.getCell(0) == null || row.getCell(0).toString().trim().isEmpty()) continue;
            --lastRowNum;
            break;
        }
        return lastRowNum;
    }
}

