**Директория данных для формирования пакета для регистрации схемы**

Директория `schemas-to-smev` предназначена для формирования пакетов, содержащих архивы с эталонами, тестовые сценарии и схемы 
с целью их регистарции в СМЭВ.

1. В директории `schemas-to-smev` расположены каталоги с именами схем, которые требуеся зарегистрировать.
2. В этих каталогах схем однотипная структура:
    - `Схема`  
      каталог для копирования xsd-схемы с зависимостями. По умолчанию пустой.
    - `Тестовый сценарий`  
      хранится xsl-сценарий
    - `Эталоны`  
      - хранится валидный запрос с ответом в каталоге `1` 
      - и невалидный запрос сответом в каталоге `2`.  
    - конфигурационный файл `build.conf`, в котором:
      - прописан список зависимостей xsd-схемы - параметр `LIST_XSD`
      - прописан список дополнительных файлов, которые нужно поместить в пакет - параметр `OTHER_FILE`.
3. В корне `schemas-to-smev` расположен скрипт `build.sh`, который:
    - принимает входной параметр (опционально) с именем директории из `schemas-to-smev` для формирования пакета
    - если параметр отсутствет, то формируются пакеты по всем директориям в составе `schemas-to-smev`
    - по каждой директории: 
        - копирует xsd-схему с зависимостями в каталог `Схема` согласно `build.conf`
        - архивирует каталоги `Схема`, `Тестовый сценарий` и `Эталоны`
        - перемещает архивы и дополнительные файлы в директорию `schemas-to-smev\target`
    
    Примеры запуска скрипта:
    - для подготовки пакетов по всем директориям из `schemas-to-smev`.  
    Из каталога `schemas-to-smev` выполнить:
        ```
        $ chmod +x ./build.sh    
        $ ./build.sh
        ```    
   - для подготовки пакета по определённой схеме из `schemas-to-smev`.  
   Из каталога `schemas-to-smev` выполнить:
       ```
       $ chmod +x ./build.sh    
       $ ./build.sh 10.05.I-1.0.6
       ```  
    
4. Полученые архивы необходимо предоставить для регистрации.


 