/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.xml;

import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.FlatFileParseException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.oxm.MarshallingFailureException;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.util.CollectionUtils;
import ru.pfrf.egisso.common.schema.generated.internal.basic.v8.InternationalPassportRFType;
import ru.pfrf.egisso.common.schema.generated.internal.basic.v8.MilitaryPassportDocumentType;
import ru.pfrf.egisso.common.schema.generated.internal.basic.v8.NotRestrictedDocumentType;
import ru.pfrf.egisso.common.schema.generated.internal.basic.v8.PassportRFType;
import ru.pfrf.egisso.common.schema.generated.internal.basic.v8.SovietPassportType;
import ru.pfrf.egisso.common.schema.generated.internal.basic.v8.TAddress;
import ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.TFactAlterationBasedOnDeathOrMovingRecalculation;
import ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.TFactAlterationBasedOnPreviousErrors;
import ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.TFactAlterationBasedOnRecalculation;
import ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.TFactAssignment;
import ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.TFactInvalidation;
import ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.TFactTermination;
import ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.TPackage;
import ru.pfrf.egisso.common.schema.generated.internal.facts.v8.TFactAssignment;
import ru.pfrf.egisso.common.schema.generated.internal.facts.v8.TNeedsCriteria;
import ru.pfrf.egisso.common.schema.generated.internal.prsn.basis.v2.TBasisPerson;
import ru.pfrf.egisso.common.schema.generated.internal.prsn.info.v4.ObjectFactory;
import ru.pfrf.egisso.common.schema.generated.internal.prsn.info.v4.TPersonInfo;
import ru.pfrf.egisso.common.schema.generated.messages.assignment.v8.Data;
import ru.pfrf.egisso.common.schema.generated.smev.supplementary.GenderType;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentLineTokenizer;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Assignment;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.BasisPerson;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Document;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.NeedsCriteria;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Recipient;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.RecipientAddress;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.xml.ExemptionFormHandler;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.xml.FormHandler;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.xml.MonetaryFormHandler;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.xml.NaturalFormHandler;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.xml.RegistryHandler;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.xml.ServiceFormHandler;

public class AssignmentRegistryHandler
implements ValidationEventHandler,
RegistryHandler<Assignment, Long> {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ru.pfrf.egisso.common.schema.generated.messages.assignment.v8.ObjectFactory requestFactory = new ru.pfrf.egisso.common.schema.generated.messages.assignment.v8.ObjectFactory();
    private final ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.ObjectFactory packageFactory = new ru.pfrf.egisso.common.schema.generated.internal.facts.pkg.v9.ObjectFactory();
    private final ObjectFactory personFactory = new ObjectFactory();
    private final ru.pfrf.egisso.common.schema.generated.internal.basic.v8.ObjectFactory basicFactory = new ru.pfrf.egisso.common.schema.generated.internal.basic.v8.ObjectFactory();
    private final ru.pfrf.egisso.common.schema.generated.internal.basic.v8.ObjectFactory smevFactory = new ru.pfrf.egisso.common.schema.generated.internal.basic.v8.ObjectFactory();
    private final ru.pfrf.egisso.common.schema.generated.internal.prsn.basis.v2.ObjectFactory basisPersonFactory = new ru.pfrf.egisso.common.schema.generated.internal.prsn.basis.v2.ObjectFactory();
    private final Map<String, FormHandler> formHandlers;
    private final Map<String, BiConsumer<TPersonInfo.Address, TAddress>> addressHandlers;
    private final Map<String, DocHandler> docHandlers;
    private Jaxb2Marshaller marshaller;
    private DatatypeFactory datatypeFactory;
    private List<String> errorMessages;

    public AssignmentRegistryHandler(List<String> errorMessages) {
        this.errorMessages = errorMessages;
        HashMap<String, FormHandler> forms = new HashMap<String, FormHandler>();
        forms.put("01", new MonetaryFormHandler());
        forms.put("02", new NaturalFormHandler());
        forms.put("03", new ExemptionFormHandler());
        forms.put("04", new ServiceFormHandler());
        this.formHandlers = Collections.unmodifiableMap(forms);
        HashMap<String, BiConsumer<TPersonInfo.Address, TAddress>> addresses = new HashMap<String, BiConsumer<TPersonInfo.Address, TAddress>>();
        addresses.put("01", TPersonInfo.Address::setPermanentResidence);
        addresses.put("02", TPersonInfo.Address::setTemporaryResidence);
        addresses.put("03", TPersonInfo.Address::setActualResidence);
        this.addressHandlers = Collections.unmodifiableMap(addresses);
        HashMap<String, DocHandler> docs = new HashMap<String, DocHandler>();
        docs.put("01", new ResidencePermitRfDocHandler());
        docs.put("02", new TemporaryIdentityCardRfDocHandler());
        docs.put("03", new PassportRfDocHandler());
        docs.put("04", new ForeignPassportDocHandler());
        docs.put("05", new BirthCertificateDocHandler());
        docs.put("06", new RefugeeCertificateDocHandler());
        docs.put("07", new MilitaryPassportDocHandler());
        docs.put("08", new OtherDocumentDocHandler());
        this.docHandlers = Collections.unmodifiableMap(docs);
        this.init();
    }

    public void init() {
        this.marshaller = new Jaxb2Marshaller();
        this.marshaller.setPackagesToScan("ru.pfrf.egisso.common.schema.generated");
        this.marshaller.setSchema(new ClassPathResource("schema/10.06.S-1.0.8.xsd"));
        this.marshaller.setValidationEventHandler(new DefaultValidationEventHandler());
        try {
            this.marshaller.afterPropertiesSet();
        }
        catch (Exception e) {
            this.logger.debug("", e);
            throw new IllegalStateException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 Jaxb2Marshaller: " + e.getMessage(), e);
        }
        try {
            this.datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            this.logger.debug("", e);
            throw new IllegalStateException("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c DatatypeFactory: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean marshall(FlatFileItemReader<Assignment> itemReader, OutputStream outputStream) {
        TPackage tPackage = this.packageFactory.createTPackage();
        tPackage.setPackageId(UUID.randomUUID().toString());
        tPackage.setElements(this.packageFactory.createTPackageElements());
        int recNumber = 0;
        boolean hasAssignment = true;
        while (hasAssignment) {
            try {
                Assignment assignment = (Assignment)itemReader.read();
                if (assignment == null) {
                    hasAssignment = false;
                    continue;
                }
                String recType = assignment.getRecType();
                int rowNumber = ++recNumber;
                Recipient recipient = null;
                switch (recType) {
                    case "Fact": {
                        recipient = assignment.getRecipient();
                        tPackage.getElements().getFact().add(this.map(assignment, (Integer)recNumber));
                        break;
                    }
                    case "Reason": {
                        recipient = assignment.getBasisPersons().get(0).getPrsnInfo();
                        if (!this.checkFact(tPackage, recNumber)) break;
                        TFactAssignment tFactAssignment = tPackage.getElements().getFact().get(tPackage.getElements().getFact().size() - 1);
                        if (tFactAssignment.getReasonPersons() == null) {
                            tFactAssignment.setReasonPersons(new TFactAssignment.ReasonPersons());
                        }
                        for (BasisPerson basisPerson : assignment.getBasisPersons()) {
                            tFactAssignment.getReasonPersons().getBasisPerson().add(this.map(basisPerson, (Integer)recNumber));
                        }
                        break;
                    }
                    case "Criteria": {
                        if (!this.checkFact(tPackage, recNumber)) break;
                        TFactAssignment tFactAssignment = tPackage.getElements().getFact().get(tPackage.getElements().getFact().size() - 1);
                        for (NeedsCriteria criteria : assignment.getNeedsCriteriaList()) {
                            tFactAssignment.getNeedsCriteria().getNeedsCriteria().add(this.map(criteria));
                        }
                        break;
                    }
                    case "AlterationBasedOnRecalculation": {
                        tPackage.getElements().getAlterationBasedOnRecalculation().add(this.mapRecalculation(assignment));
                        break;
                    }
                    case "AlterationBasedOnDeathOrMovingRecalculation": {
                        tPackage.getElements().getAlterationBasedOnDeathOrMovingRecalculation().add(this.mapMovingRecalculation(assignment));
                        break;
                    }
                    case "AlterationBasedOnPreviousErrors": {
                        tPackage.getElements().getAlterationBasedOnPreviousErrors().add(this.mapPreviousErrors(assignment, recNumber));
                        break;
                    }
                    case "TerminationBasedOnRecalculation": {
                        tPackage.getElements().getTerminationBasedOnRecalculation().add(this.mapTermination(assignment));
                        break;
                    }
                    case "TerminationBasedOnIneligibility": {
                        tPackage.getElements().getTerminationBasedOnIneligibility().add(this.mapTermination(assignment));
                        break;
                    }
                    case "TerminationBasedOnEndOfRight": {
                        tPackage.getElements().getTerminationBasedOnEndOfRight().add(this.mapTermination(assignment));
                        break;
                    }
                    case "TerminationBasedOnEndOfValidityPeriod": {
                        tPackage.getElements().getTerminationBasedOnEndOfValidityPeriod().add(this.mapTermination(assignment));
                        break;
                    }
                    case "DuplicatesInvalidation": {
                        tPackage.getElements().getDuplicatesInvalidation().add(this.mapInvalidation(assignment));
                        break;
                    }
                    case "ErrorsInvalidation": {
                        tPackage.getElements().getErrorsInvalidation().add(this.mapInvalidation(assignment));
                        break;
                    }
                    default: {
                        this.errorMessages.add(String.format("\u0421\u0442\u0440\u043e\u043a\u0430 %s, \u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u041f\u043e\u043b\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '%s'", recNumber, "RecType", recType));
                    }
                }
                for (String errorString : assignment.getErrorMessages()) {
                    this.errorMessages.add("\u0421\u0442\u0440\u043e\u043a\u0430 " + rowNumber + " " + this.getPersonFioWithSnils(recipient) + ", " + errorString);
                }
            }
            catch (FlatFileParseException e) {
                this.logger.error("", e);
                int fieldNumber = e.getInput().split(";").length;
                int columnNumber = AssignmentLineTokenizer.COLUMNS.length;
                if (fieldNumber != columnNumber) {
                    this.errorMessages.add(String.format("\u0421\u0442\u0440\u043e\u043a\u0430 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e %s \u043f\u043e\u043b\u0435\u0439, \u0442\u0440\u0435\u0431\u0443\u0435\u043c\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u2014 %s", recNumber, fieldNumber, columnNumber));
                    continue;
                }
                this.errorMessages.add(String.format("\u0421\u0442\u0440\u043e\u043a\u0430 %s. \u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u0439\u043b\u0430: %s", recNumber, e.getMessage()));
            }
            catch (Exception e) {
                this.logger.error("", e);
                this.errorMessages.add(String.format("\u0421\u0442\u0440\u043e\u043a\u0430 %s. \u041e\u0448\u0438\u0431\u043a\u0430: %s", recNumber, e.getMessage() != null ? e.getMessage() : e));
            }
        }
        if (this.errorMessages.size() == 0) {
            Data request = this.requestFactory.createData();
            request.setPackage(tPackage);
            try {
                StreamResult streamResult = new StreamResult(outputStream);
                this.marshaller.setValidationEventHandler(this);
                this.marshaller.marshal(request, streamResult);
            }
            catch (MarshallingFailureException e) {
                this.logger.error("", e);
                if (e.getCause() != null && e.getCause() instanceof JAXBException) {
                    JAXBException jaxbException = (JAXBException)e.getCause();
                    this.errorMessages.add("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043c\u0430\u0440\u0448\u0430\u043b\u0438\u043d\u0433\u0435: " + jaxbException.getLinkedException().getMessage());
                } else {
                    this.errorMessages.add("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043c\u0430\u0440\u0448\u0430\u043b\u0438\u043d\u0433\u0435: " + e.getMessage());
                }
            }
            catch (Exception ex) {
                this.logger.error("", ex);
                this.errorMessages.add("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043c\u0430\u0440\u0448\u0430\u043b\u0438\u043d\u0433\u0435: " + ex.getMessage());
            }
        }
        return true;
    }

    private String getPersonFioWithSnils(Recipient recipient) {
        if (recipient == null) {
            return null;
        }
        StringBuilder fioWithSnils = new StringBuilder().append("\u0424\u0418\u041e:");
        if (recipient.getFirstName() == null && recipient.getLastName() == null && recipient.getMiddleName() == null) {
            fioWithSnils.append(" \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b");
        }
        if (recipient.getFirstName() != null) {
            fioWithSnils.append(" ").append(recipient.getFirstName());
        }
        if (recipient.getLastName() != null) {
            fioWithSnils.append(" ").append(recipient.getLastName());
        }
        if (recipient.getMiddleName() != null) {
            fioWithSnils.append(" ").append(recipient.getMiddleName());
        }
        if (recipient.getSnils() != null) {
            fioWithSnils.append(" \u0421\u041d\u0418\u041b\u0421: ").append(recipient.getSnils());
        } else {
            fioWithSnils.append(" \u0421\u041d\u0418\u041b\u0421: \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d");
        }
        return fioWithSnils.toString();
    }

    private boolean checkFact(TPackage tPackage, int recNumber) {
        if (tPackage.getElements().getFact().isEmpty()) {
            this.errorMessages.add(String.format("\u0421\u0442\u0440\u043e\u043a\u0430 %s. \u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0437\u0430\u043f\u0438\u0441\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u0430\u043a\u0442 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", recNumber));
            return false;
        }
        return true;
    }

    private TFactTermination mapTermination(Assignment assignment) {
        TFactTermination tFactTermination = this.packageFactory.createTFactTermination();
        if (assignment.getProviderCode() != null) {
            tFactTermination.setProviderCode(assignment.getProviderCode().getCode());
        }
        tFactTermination.setAssignmentFactUuid(Objects.toString(assignment.getAssignmentFactUuid(), null));
        tFactTermination.setDateFinish(this.map(assignment.getEndDate()));
        tFactTermination.setUuid(Objects.toString(assignment.getUuid(), null));
        return tFactTermination;
    }

    private TFactInvalidation mapInvalidation(Assignment assignment) {
        TFactInvalidation tFactInvalidation = this.packageFactory.createTFactInvalidation();
        tFactInvalidation.setUuid(Objects.toString(assignment.getUuid(), null));
        tFactInvalidation.setAssignmentFactUuid(Objects.toString(assignment.getAssignmentFactUuid(), null));
        if (assignment.getProviderCode() != null) {
            tFactInvalidation.setProviderCode(assignment.getProviderCode().getCode());
        }
        return tFactInvalidation;
    }

    private TFactAlterationBasedOnRecalculation mapRecalculation(Assignment assignment) {
        TFactAlterationBasedOnRecalculation tFactAlterationBasedOnRecalculation = this.packageFactory.createTFactAlterationBasedOnRecalculation();
        if (assignment.getProviderCode() != null) {
            tFactAlterationBasedOnRecalculation.setProviderCode(assignment.getProviderCode().getCode());
        }
        tFactAlterationBasedOnRecalculation.setAssignmentFactUuid(Objects.toString(assignment.getAssignmentFactUuid(), null));
        tFactAlterationBasedOnRecalculation.setUuid(Objects.toString(assignment.getUuid(), null));
        tFactAlterationBasedOnRecalculation.setAmount(assignment.getQuantity());
        return tFactAlterationBasedOnRecalculation;
    }

    private TFactAlterationBasedOnDeathOrMovingRecalculation mapMovingRecalculation(Assignment assignment) {
        TFactAlterationBasedOnDeathOrMovingRecalculation tFactAlterationBasedOnDeathOrMovingRecalculation = this.packageFactory.createTFactAlterationBasedOnDeathOrMovingRecalculation();
        if (assignment.getProviderCode() != null) {
            tFactAlterationBasedOnDeathOrMovingRecalculation.setProviderCode(assignment.getProviderCode().getCode());
        }
        tFactAlterationBasedOnDeathOrMovingRecalculation.setAssignmentFactUuid(Objects.toString(assignment.getAssignmentFactUuid(), null));
        tFactAlterationBasedOnDeathOrMovingRecalculation.setUuid(Objects.toString(assignment.getUuid(), null));
        tFactAlterationBasedOnDeathOrMovingRecalculation.setAmount(assignment.getQuantity());
        tFactAlterationBasedOnDeathOrMovingRecalculation.setDateFinish(this.map(assignment.getEndDate()));
        return tFactAlterationBasedOnDeathOrMovingRecalculation;
    }

    private TFactAlterationBasedOnPreviousErrors mapPreviousErrors(Assignment assignment, Integer row) {
        TFactAlterationBasedOnPreviousErrors tFactAlterationBasedOnPreviousErrors = this.packageFactory.createTFactAlterationBasedOnPreviousErrors();
        if (assignment.getProviderCode() != null) {
            tFactAlterationBasedOnPreviousErrors.setProviderCode(assignment.getProviderCode().getCode());
        }
        tFactAlterationBasedOnPreviousErrors.setAssignmentFactUuid(Objects.toString(assignment.getAssignmentFactUuid(), null));
        tFactAlterationBasedOnPreviousErrors.setUuid(Objects.toString(assignment.getUuid(), null));
        tFactAlterationBasedOnPreviousErrors.setFact(this.map(assignment, row));
        return tFactAlterationBasedOnPreviousErrors;
    }

    private TFactAssignment map(Assignment assignment, Integer row) {
        TFactAssignment tFactAssignment = this.packageFactory.createTFactAssignment();
        Recipient recipient = assignment.getRecipient();
        if (assignment.getPackageId() != null) {
            assignment.setUuid(UUID.randomUUID());
        }
        tFactAssignment.setUuid(Objects.toString(assignment.getUuid(), null));
        tFactAssignment.setOszCode(assignment.getOsz().getCode());
        if (assignment.getLmszProviderCode() != null) {
            tFactAssignment.setLmszProviderCode(assignment.getLmszProviderCode().getCode());
        }
        tFactAssignment.setMszReceiver(this.map(recipient, row));
        if (!CollectionUtils.isEmpty(assignment.getBasisPersons())) {
            tFactAssignment.setReasonPersons(new TFactAssignment.ReasonPersons());
            assignment.getBasisPersons().forEach(person -> tFactAssignment.getReasonPersons().getBasisPerson().add(this.map((BasisPerson)person, row)));
        }
        tFactAssignment.setLmszId(Objects.toString(assignment.getMszUuid(), null));
        tFactAssignment.setCategoryId(Objects.toString(assignment.getLocalUuid(), null));
        tFactAssignment.setDecisionDate(this.map(assignment.getDecisionDate()));
        tFactAssignment.setDateStart(this.map(assignment.getBeginDate()));
        tFactAssignment.setDateFinish(this.map(assignment.getEndDate()));
        if (!CollectionUtils.isEmpty(assignment.getDocuments())) {
            tFactAssignment.setDocuments(new TFactAssignment.Documents());
            assignment.getDocuments().forEach(document -> tFactAssignment.getDocuments().getDocument().add(this.map((Document)document)));
        }
        tFactAssignment.setNeedsCriteria(new TFactAssignment.NeedsCriteria());
        if (!CollectionUtils.isEmpty(assignment.getNeedsCriteriaList())) {
            tFactAssignment.setNeedsCriteria(new TFactAssignment.NeedsCriteria());
            assignment.getNeedsCriteriaList().forEach(needsCriteria -> tFactAssignment.getNeedsCriteria().getNeedsCriteria().add(this.map((NeedsCriteria)needsCriteria)));
        }
        if (assignment.getCriteriaUsing() != null) {
            tFactAssignment.getNeedsCriteria().setUsingSign(assignment.getCriteriaUsing());
        }
        tFactAssignment.setAssignmentInfo(new TFactAssignment.AssignmentInfo());
        FormHandler formHandler = this.formHandlers.get(assignment.getGrantingForm().getCode());
        if (formHandler == null) {
            this.errorMessages.add(String.format("\u0421\u0442\u0440\u043e\u043a\u0430 %s, %s \u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u0412 \u0444\u0430\u043a\u0442\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u041c\u0421\u0417 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f: [code='%s']", row, this.getPersonFioWithSnils(recipient), "FormCode", assignment.getGrantingForm().getCode()));
        } else {
            formHandler.accept(tFactAssignment.getAssignmentInfo(), assignment);
        }
        return tFactAssignment;
    }

    private TFactAssignment.Documents.Document map(Document document) {
        TFactAssignment.Documents.Document tDocument = new TFactAssignment.Documents.Document();
        tDocument.setTitle(document.getName());
        tDocument.setSeries(document.getSeries());
        tDocument.setNumber(document.getNumber());
        tDocument.setIssueDate(this.map(document.getIssueDate()));
        tDocument.setAuthority(document.getAuthority());
        tDocument.setStartDate(this.map(document.getBeginDate()));
        tDocument.setFinishDate(this.map(document.getEndDate()));
        return tDocument;
    }

    private TNeedsCriteria map(NeedsCriteria needsCriteria) {
        TNeedsCriteria tNeedsCriteria = new TNeedsCriteria();
        tNeedsCriteria.setNeedsCriteriaCode(needsCriteria.getCode());
        return tNeedsCriteria;
    }

    private TBasisPerson map(BasisPerson basisPerson, Integer row) {
        TBasisPerson tBasisPerson = this.basisPersonFactory.createTBasisPerson();
        tBasisPerson.setPrsnInfo(this.map(basisPerson.getPrsnInfo(), row));
        tBasisPerson.setKinshipTypeCode(basisPerson.getKinshipTypeCode());
        return tBasisPerson;
    }

    private TPersonInfo map(Recipient person, Integer row) {
        TPersonInfo tPersonInfo = this.personFactory.createTPersonInfo();
        tPersonInfo.setSNILS(person.getSnils());
        tPersonInfo.setFamilyName(person.getLastName());
        tPersonInfo.setFirstName(person.getFirstName());
        if (!StringUtils.isEmpty(person.getMiddleName())) {
            tPersonInfo.setPatronymic(person.getMiddleName());
        }
        tPersonInfo.setMaidenFamilyName(person.getMaidenName());
        tPersonInfo.setGender(Character.valueOf('M').equals(person.getGender()) ? GenderType.MALE : GenderType.FEMALE);
        tPersonInfo.setBirthDate(this.map(person.getBirthDate()));
        tPersonInfo.setBirthPlace(person.getBirthPlace());
        tPersonInfo.setPhoneNumber(person.getPhone());
        if (person.getCitizenship() != null) {
            tPersonInfo.setCitizenship(person.getCitizenship().getCode());
        }
        if (person.getDocType() != null) {
            tPersonInfo.setIdentityDoc(new TPersonInfo.IdentityDoc());
            DocHandler handler = this.docHandlers.get(person.getDocType().getCode());
            if (handler == null) {
                this.errorMessages.add(String.format("\u0421\u0442\u0440\u043e\u043a\u0430 %s, %s \u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0414\u0423\u041b \u0444\u0438\u0437. \u043b\u0438\u0446\u0430: [code='%s']", row, this.getPersonFioWithSnils(person), "doctype_reason", person.getDocType().getCode()));
            } else {
                handler.accept(tPersonInfo.getIdentityDoc(), person);
            }
        }
        if (!CollectionUtils.isEmpty(person.getAddresses())) {
            tPersonInfo.setAddress(new TPersonInfo.Address());
            person.getAddresses().forEach(address -> {
                TAddress tAddress = this.map((RecipientAddress)address);
                BiConsumer<TPersonInfo.Address, TAddress> handler = this.addressHandlers.get(address.getAddress().getCode());
                if (handler == null) {
                    this.errorMessages.add(String.format("\u0421\u0442\u0440\u043e\u043a\u0430 %s, %s \u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0430\u0434\u0440\u0435\u0441\u0430 \u0444\u0438\u0437. \u043b\u0438\u0446\u0430: [code='%s']", row, this.getPersonFioWithSnils(person), "LMSZProviderCode", address.getAddress().getCode()));
                } else {
                    handler.accept(tPersonInfo.getAddress(), tAddress);
                }
            });
        }
        tPersonInfo.setResidencePermitInfo(person.getResidenceDoc());
        return tPersonInfo;
    }

    private TAddress map(RecipientAddress address) {
        TAddress tAddress = this.basicFactory.createTAddress();
        tAddress.setOKSMCode(address.getCountry().getCode());
        tAddress.setPostIndex(address.getPostIndex());
        tAddress.setRegion(address.getRegion());
        tAddress.setDistrict(address.getDistrict());
        tAddress.setCity(address.getCity());
        tAddress.setStreet(address.getStreet());
        tAddress.setHouse(address.getHouse());
        tAddress.setHousing(address.getBuilding());
        tAddress.setApartment(address.getFlat());
        return tAddress;
    }

    private XMLGregorianCalendar map(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return this.datatypeFactory.newXMLGregorianCalendar(calendar);
    }

    @Override
    public boolean handleEvent(ValidationEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (1 == event.getSeverity() || 2 == event.getSeverity()) {
            this.errorMessages.add("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u043e\u0439 xml \u043f\u043e xsd-\u0441\u0445\u0435\u043c\u0435: " + event.getMessage());
        }
        return true;
    }

    private class OtherDocumentDocHandler
    implements DocHandler {
        private OtherDocumentDocHandler() {
        }

        @Override
        public void accept(TPersonInfo.IdentityDoc identityDoc, Recipient recipient) {
            NotRestrictedDocumentType doc = AssignmentRegistryHandler.this.smevFactory.createNotRestrictedDocumentType();
            doc.setSeries(recipient.getDocSeries());
            doc.setNumber(recipient.getDocNumber());
            doc.setIssueDate(AssignmentRegistryHandler.this.map(recipient.getDocIssueDate()));
            doc.setIssuer(recipient.getDocAuthority());
            identityDoc.setOtherDocument(doc);
        }
    }

    private class RefugeeCertificateDocHandler
    implements DocHandler {
        private RefugeeCertificateDocHandler() {
        }

        @Override
        public void accept(TPersonInfo.IdentityDoc identityDoc, Recipient recipient) {
            InternationalPassportRFType doc = AssignmentRegistryHandler.this.smevFactory.createInternationalPassportRFType();
            doc.setSeries(recipient.getDocSeries());
            doc.setNumber(recipient.getDocNumber());
            doc.setIssueDate(AssignmentRegistryHandler.this.map(recipient.getDocIssueDate()));
            doc.setIssuer(recipient.getDocAuthority());
            identityDoc.setRefugeeCertificate(doc);
        }
    }

    private class TemporaryIdentityCardRfDocHandler
    implements DocHandler {
        private TemporaryIdentityCardRfDocHandler() {
        }

        @Override
        public void accept(TPersonInfo.IdentityDoc identityDoc, Recipient recipient) {
            NotRestrictedDocumentType doc = AssignmentRegistryHandler.this.smevFactory.createNotRestrictedDocumentType();
            doc.setSeries(recipient.getDocSeries());
            doc.setNumber(recipient.getDocNumber());
            doc.setIssueDate(AssignmentRegistryHandler.this.map(recipient.getDocIssueDate()));
            doc.setIssuer(recipient.getDocAuthority());
            identityDoc.setTemporaryIdentityCardRF(doc);
        }
    }

    private class BirthCertificateDocHandler
    implements DocHandler {
        private BirthCertificateDocHandler() {
        }

        @Override
        public void accept(TPersonInfo.IdentityDoc identityDoc, Recipient recipient) {
            SovietPassportType doc = AssignmentRegistryHandler.this.smevFactory.createSovietPassportType();
            doc.setSeries(recipient.getDocSeries());
            doc.setNumber(recipient.getDocNumber());
            doc.setIssueDate(AssignmentRegistryHandler.this.map(recipient.getDocIssueDate()));
            doc.setIssuer(recipient.getDocAuthority());
            identityDoc.setBirthCertificate(doc);
        }
    }

    private class MilitaryPassportDocHandler
    implements DocHandler {
        private MilitaryPassportDocHandler() {
        }

        @Override
        public void accept(TPersonInfo.IdentityDoc identityDoc, Recipient recipient) {
            MilitaryPassportDocumentType doc = AssignmentRegistryHandler.this.smevFactory.createMilitaryPassportDocumentType();
            doc.setSeries(recipient.getDocSeries());
            doc.setNumber(recipient.getDocNumber());
            doc.setIssueDate(AssignmentRegistryHandler.this.map(recipient.getDocIssueDate()));
            doc.setIssuer(recipient.getDocAuthority());
            identityDoc.setMilitaryPassport(doc);
        }
    }

    private class ResidencePermitRfDocHandler
    implements DocHandler {
        private ResidencePermitRfDocHandler() {
        }

        @Override
        public void accept(TPersonInfo.IdentityDoc identityDoc, Recipient recipient) {
            InternationalPassportRFType doc = AssignmentRegistryHandler.this.smevFactory.createInternationalPassportRFType();
            doc.setSeries(recipient.getDocSeries());
            doc.setNumber(recipient.getDocNumber());
            doc.setIssueDate(AssignmentRegistryHandler.this.map(recipient.getDocIssueDate()));
            doc.setIssuer(recipient.getDocAuthority());
            identityDoc.setResidencePermitRF(doc);
        }
    }

    private class ForeignPassportDocHandler
    implements DocHandler {
        private ForeignPassportDocHandler() {
        }

        @Override
        public void accept(TPersonInfo.IdentityDoc identityDoc, Recipient recipient) {
            NotRestrictedDocumentType doc = AssignmentRegistryHandler.this.smevFactory.createNotRestrictedDocumentType();
            doc.setSeries(recipient.getDocSeries());
            doc.setNumber(recipient.getDocNumber());
            doc.setIssueDate(AssignmentRegistryHandler.this.map(recipient.getDocIssueDate()));
            doc.setIssuer(recipient.getDocAuthority());
            identityDoc.setForeignPassport(doc);
        }
    }

    private class PassportRfDocHandler
    implements DocHandler {
        private PassportRfDocHandler() {
        }

        @Override
        public void accept(TPersonInfo.IdentityDoc identityDoc, Recipient recipient) {
            PassportRFType doc = AssignmentRegistryHandler.this.smevFactory.createPassportRFType();
            doc.setSeries(recipient.getDocSeries());
            doc.setNumber(recipient.getDocNumber());
            doc.setIssueDate(AssignmentRegistryHandler.this.map(recipient.getDocIssueDate()));
            doc.setIssuer(recipient.getDocAuthority());
            identityDoc.setPassportRF(doc);
        }
    }

    private static interface DocHandler
    extends BiConsumer<TPersonInfo.IdentityDoc, Recipient> {
    }
}

