/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentFieldSetConstants;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.CsvMapperValidate;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Assignment;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.BasisPerson;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Identity;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Recipient;

public class ReasonFiledSetMapper
extends CsvMapperValidate
implements FieldSetMapper<Assignment>,
AssignmentFieldSetConstants {
    @Override
    public Assignment mapFieldSet(FieldSet fieldSet) {
        Assignment result = new Assignment();
        this.errorMessages = new ArrayList();
        result.setErrorMessages(this.errorMessages);
        result.setRecType(fieldSet.readString("RecType"));
        BasisPerson basisPerson = new BasisPerson();
        basisPerson.setPrsnInfo(this.mapReasonFieldSet(fieldSet));
        if (!fieldSet.readString("kinshipTypeCode").isEmpty()) {
            String kinshipTypeCode = this.setKinshipTypeCode(fieldSet, "kinshipTypeCode");
            basisPerson.setKinshipTypeCode(StringUtils.isBlank(kinshipTypeCode) ? null : kinshipTypeCode);
        }
        result.getBasisPersons().add(basisPerson);
        return result;
    }

    private Recipient mapReasonFieldSet(FieldSet fieldSet) {
        Recipient result = new Recipient();
        result.setSnils(this.setNotEmptySnils(fieldSet, "SNILS_reason"));
        result.setLastName(this.setNotEmptyName(fieldSet, "FamilyName_reason"));
        result.setFirstName(this.setNotEmptyName(fieldSet, "Name_reason"));
        if (!fieldSet.readString("Patronymic_reason").isEmpty()) {
            result.setMiddleName(this.setName(fieldSet, "Patronymic_reason"));
        }
        result.setGender(this.setGender(fieldSet, "Gender_reason"));
        result.setBirthDate(this.setNotEmptyDate(fieldSet, "BirthDate_reason"));
        String docTypeString = fieldSet.readString("doctype_reason");
        if (StringUtils.isNotBlank(docTypeString)) {
            if (docTypeString.length() < 2) {
                docTypeString = "0" + docTypeString;
            }
            result.setDocType(new Identity(docTypeString));
            result.setDocSeries(this.setNotEmptyDocSeries(fieldSet, "doc_Series_reason", docTypeString));
            result.setDocNumber(this.setNotEmptyDocNumber(fieldSet, "doc_Number_reason", docTypeString));
            result.setDocIssueDate(this.setNotEmptyDate(fieldSet, "doc_IssueDate_reason"));
            result.setDocAuthority(this.setNotEmptyIssuer(fieldSet, "doc_Issuer_reason"));
        }
        return result;
    }
}

