/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.item.file.transform.FieldSet;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.DocumentType;

public abstract class CsvMapperValidate {
    private static final String YES = "\u0414\u0430";
    private static final String NO = "\u041d\u0435\u0442";
    protected List<String> errorMessages = new ArrayList<String>();

    protected Date setDate(FieldSet fieldSet, String columnName) {
        try {
            return fieldSet.readDate(columnName);
        }
        catch (Exception e) {
            this.errorMessages.add(String.format("\u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u0414\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 DD.MM.YYYY", columnName));
            return null;
        }
    }

    protected Date setNotEmptyDate(FieldSet fieldSet, String columnName) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            return this.setDate(fieldSet, columnName);
        }
        return null;
    }

    protected Character setGender(FieldSet fieldSet, String columnName) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            if (Character.valueOf('\u041c').equals(Character.valueOf(fieldSet.readChar(columnName)))) {
                return Character.valueOf('M');
            }
            if (Character.valueOf('\u0416').equals(Character.valueOf(fieldSet.readChar(columnName)))) {
                return Character.valueOf('F');
            }
            this.errorMessages.add(String.format("\u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u041f\u043e\u043b\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u0443\u043a\u0432\u044b \u041c \u0438\u043b\u0438 \u0416", columnName));
        }
        return null;
    }

    protected BigDecimal setAmount(FieldSet fieldSet, String columnName) {
        String amount;
        if (this.isNotEmpty(fieldSet, columnName) && StringUtils.isNotBlank(amount = this.setStringByMask(fieldSet, columnName, "[0-9]*\\,?[0-9]+"))) {
            return new BigDecimal(amount.replace(",", "."));
        }
        return null;
    }

    protected Boolean setBoolean(FieldSet fieldSet, String columnName) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            if (!YES.equalsIgnoreCase(fieldSet.readString(columnName)) && !NO.equalsIgnoreCase(fieldSet.readString(columnName))) {
                this.errorMessages.add(String.format("\u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043a\u0430\u043a  '\u0414\u0430' \u0438\u043b\u0438 '\u041d\u0435\u0442' \u0431\u0435\u0437 \u0443\u0447\u0451\u0442\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430", columnName));
            } else {
                return YES.equalsIgnoreCase(fieldSet.readString(columnName)) ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return null;
    }

    protected UUID setUUID(FieldSet fieldSet, String columnName) {
        try {
            return UUID.fromString(fieldSet.readString(columnName));
        }
        catch (Exception e) {
            this.errorMessages.add(String.format("\u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043f\u043e\u043b\u044f UUID", columnName));
            return null;
        }
    }

    protected UUID setNotEmptyUUID(FieldSet fieldSet, String columnName) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            return this.setUUID(fieldSet, columnName);
        }
        return null;
    }

    protected String setParticipantCode(FieldSet fieldSet, String columnName) {
        return this.setStringByMask(fieldSet, columnName, "[A-HJ-NP-Z0-9]{4}\\.\\d{6}");
    }

    protected String setNotNullParticipantCode(FieldSet fieldSet, String columnName) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            return this.setParticipantCode(fieldSet, columnName);
        }
        return null;
    }

    protected String setSnils(FieldSet fieldSet, String columnName) {
        return this.setStringByMask(fieldSet, columnName, "\\d{11}");
    }

    protected String setNotEmptySnils(FieldSet fieldSet, String columnName) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            return this.setSnils(fieldSet, columnName);
        }
        return null;
    }

    protected String setName(FieldSet fieldSet, String columnName) {
        this.lessOrEqualsSize(fieldSet, columnName, 100);
        return this.setStringByMask(fieldSet, columnName, "[\u0430-\u044f\u0410-\u042f\u0451\u0401\\-0-9][\u0430-\u044f\u0410-\u042f\u0451\u0401\\-\\s',.]*");
    }

    protected String setNotEmptyName(FieldSet fieldSet, String columnName) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            return this.setName(fieldSet, columnName);
        }
        return null;
    }

    protected String setIssuer(FieldSet fieldSet, String columnName) {
        this.lessOrEqualsSize(fieldSet, columnName, 200);
        return this.setStringByMask(fieldSet, columnName, "[\u0430-\u044f\u0410-\u042f\u0451\u0401\\-0-9\u2116(][\u0430-\u044f\u0410-\u042f\u0451\u0401\\-\\s',.0-9()\u2116\"\\\\/]*");
    }

    protected String setNotEmptyIssuer(FieldSet fieldSet, String columnName) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            return this.setIssuer(fieldSet, columnName);
        }
        return null;
    }

    protected String setDocSeries(FieldSet fieldSet, String columnName, String type) {
        if (!this.lessOrEqualsSize(fieldSet, columnName, 20)) {
            return null;
        }
        return this.setStringByMask(fieldSet, columnName, this.returnRegexForDocSeriesByDocType(type));
    }

    protected String setNotEmptyDocSeries(FieldSet fieldSet, String columnName, String type) {
        if (this.isRequiredFieldForThisDocType(type)) {
            if (this.isNotEmpty(fieldSet, columnName)) {
                return this.setDocSeries(fieldSet, columnName, type);
            }
            return null;
        }
        return this.setDocSeries(fieldSet, columnName, type);
    }

    protected String setDocNumber(FieldSet fieldSet, String columnName, String type) {
        return this.setStringByMask(fieldSet, columnName, this.returnRegexForDocNumberByDocType(type));
    }

    protected String setNotEmptyDocNumber(FieldSet fieldSet, String columnName, String type) {
        if (this.isNotEmpty(fieldSet, columnName)) {
            return this.setDocNumber(fieldSet, columnName, type);
        }
        return null;
    }

    protected String setKinshipTypeCode(FieldSet fieldSet, String columnName) {
        return this.setStringByMask(fieldSet, columnName, "\\d{7}");
    }

    protected String setCriteria(FieldSet fieldSet, String columnName) {
        this.lessOrEqualsSize(fieldSet, columnName, 500);
        return fieldSet.readString(columnName);
    }

    protected String setMeasuryCode(FieldSet fieldSet, String columnName) {
        String result = fieldSet.readString(columnName);
        if (StringUtils.isNotBlank(result) && result.length() != 2) {
            this.setStringByMask(fieldSet, columnName, "(\\d{3})|(\\d{4})");
        }
        return result;
    }

    protected String setString200(FieldSet fieldSet, String columnName) {
        this.lessOrEqualsSize(fieldSet, columnName, 200);
        return fieldSet.readString(columnName);
    }

    private String setStringByMask(FieldSet fieldSet, String columnName, String regex) {
        String result = fieldSet.readString(columnName);
        if (StringUtils.isNotBlank(result)) {
            if (result.matches(regex)) {
                return result;
            }
            this.errorMessages.add(String.format("\u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '%s' \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043c\u0430\u0441\u043a\u0435: '%s'", columnName, result, regex));
        }
        return null;
    }

    private boolean lessOrEqualsSize(FieldSet fieldSet, String columnName, int size) {
        String result = fieldSet.readString(columnName);
        if (result.length() > size) {
            this.errorMessages.add(String.format("\u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u043e\u043b\u044f \u0431\u043e\u043b\u044c\u0448\u0435, \u0447\u0435\u043c \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0432 %s \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432", columnName, size));
            return false;
        }
        return true;
    }

    protected boolean isNotEmpty(FieldSet fieldSet, String columnName) {
        String result = fieldSet.readString(columnName);
        if (StringUtils.isBlank(result)) {
            this.errorMessages.add(String.format("\u043f\u043e\u043b\u0435 %s. \u041e\u0448\u0438\u0431\u043a\u0430: \u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442, \u0445\u043e\u0442\u044f \u043f\u043e\u043b\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c", columnName));
            return false;
        }
        return true;
    }

    private boolean isRequiredFieldForThisDocType(String typeDoc) {
        return !typeDoc.equals(DocumentType.TEMPORARY_IDENTITY_CARD.getCode()) && !typeDoc.equals(DocumentType.PASSPORT_IN.getCode()) && !typeDoc.equals(DocumentType.OTHER_DOCUMENTS.getCode());
    }

    private String returnRegexForDocSeriesByDocType(String typeDoc) {
        String regex = typeDoc.equals(DocumentType.TEMPORARY_IDENTITY_CARD.getCode()) || typeDoc.equals(DocumentType.PASSPORT_IN.getCode()) || typeDoc.equals(DocumentType.OTHER_DOCUMENTS.getCode()) ? ".*" : (typeDoc.equals(DocumentType.RESIDENCE_PERMIT.getCode()) || typeDoc.equals(DocumentType.REFUGEE_CERTIFICATE.getCode()) ? "\\d{2}" : (typeDoc.equals(DocumentType.PASSPORT_RF.getCode()) ? "\\d{4}" : (typeDoc.equals(DocumentType.BIRTH_CERTIFICATE.getCode()) ? "[IVXLCDM]{1,10}[\\-][\u0410-\u042f]{2}" : "[\u0410-\u042f]{2}")));
        return regex;
    }

    private String returnRegexForDocNumberByDocType(String typeDoc) {
        String regex = typeDoc.equals(DocumentType.RESIDENCE_PERMIT.getCode()) || typeDoc.equals(DocumentType.REFUGEE_CERTIFICATE.getCode()) || typeDoc.equals(DocumentType.ARMY_CERTIFICATE.getCode()) ? "\\d{7}" : (typeDoc.equals(DocumentType.PASSPORT_RF.getCode()) || typeDoc.equals(DocumentType.BIRTH_CERTIFICATE.getCode()) ? "\\d{6}" : "[0-9\u0430-\u044f\u0410-\u042fA-Za-z]{1,25}");
        return regex;
    }
}

