/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.item.file.transform.DefaultFieldSetFactory;
import org.springframework.batch.item.file.transform.DelimitedLineTokenizer;
import org.springframework.stereotype.Component;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentFieldSetConstants;

@Component
public class AssignmentLineTokenizer
extends DelimitedLineTokenizer
implements AssignmentFieldSetConstants {
    public static final String[] COLUMNS = new String[]{"RecType", "assignmentFactUuid", "LMSZID", "categoryID", "ONMSZCode", "LMSZProviderCode", "providerCode", "SNILS_recip", "FamilyName_recip", "Name_recip", "Patronymic_recip", "Gender_recip", "BirthDate_recip", "doctype_recip", "doc_Series_recip", "doc_Number_recip", "doc_IssueDate_recip", "doc_Issuer_recip", "SNILS_reason", "FamilyName_reason", "Name_reason", "Patronymic_reason", "Gender_reason", "BirthDate_reason", "doctype_reason", "doc_Series_reason", "doc_Number_reason", "doc_IssueDate_reason", "doc_Issuer_reason", "decision_date", "dateStart", "dateFinish", "usingSign", "criteria", "criteriaCode", "FormCode", "amount", "measuryCode", "monetization", "content", "comment", "equivalentAmount", "kinshipTypeCode"};
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private static final DecimalFormatSymbols DECIMAL_FORMAT_SYMBOLS = DecimalFormatSymbols.getInstance();
    private static final NumberFormat NUMBER_FORMAT = new DecimalFormat("###.##", DECIMAL_FORMAT_SYMBOLS);

    public AssignmentLineTokenizer(String[] titleColumns) {
        super(";");
        DECIMAL_FORMAT_SYMBOLS.setDecimalSeparator(',');
        this.init(titleColumns);
    }

    public void init(String[] titleColumns) {
        Optional<String> analyze = this.analyzeTitle(titleColumns);
        if (analyze.isPresent()) {
            throw new IllegalStateException("\u041d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0431\u043e\u0440 \u043f\u043e\u043b\u0435\u0439: " + analyze.get());
        }
        this.setNames(titleColumns);
        DefaultFieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();
        DATE_FORMAT.setLenient(false);
        fieldSetFactory.setDateFormat(DATE_FORMAT);
        fieldSetFactory.setNumberFormat(NUMBER_FORMAT);
        this.setFieldSetFactory(fieldSetFactory);
    }

    private Optional<String> analyzeTitle(String[] titles) {
        HashSet<String> standartTitle = new HashSet<String>(Arrays.asList(COLUMNS));
        HashSet<String> setTitle = new HashSet<String>();
        String result = new String();
        for (String t : titles) {
            if (setTitle.contains(t)) {
                result = result + "\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430 '" + t + "'. ";
                continue;
            }
            if (!standartTitle.contains(t)) {
                result = result + "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a '" + t + "'. ";
                continue;
            }
            setTitle.add(t);
        }
        if (StringUtils.isNotBlank(result)) {
            result = result + "\n";
        }
        HashSet<String> setTitleNameCopy = new HashSet<String>(standartTitle);
        setTitleNameCopy.removeAll(setTitle);
        for (String t : setTitleNameCopy) {
            result = result + "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a '" + t + "'. ";
        }
        return StringUtils.isBlank(result) ? Optional.empty() : Optional.ofNullable(result);
    }
}

