/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.transform.FieldSet;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentFieldSetConstants;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.CsvMapperValidate;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Assignment;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.BasisPerson;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.FormOfGranting;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Identity;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.NeedsCriteria;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Participant;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Recipient;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.UnitsOfMeasure;

public class AssignmentFieldSetMapper
extends CsvMapperValidate
implements FieldSetMapper<Assignment>,
AssignmentFieldSetConstants {
    private static final String FACT = "Fact";
    private static final String ALTERNATION_BASED_ON_PREVIOUS_ERRORS = "AlterationBasedOnPreviousErrors";
    private Participant provider;

    public AssignmentFieldSetMapper(Participant provider) {
        this.provider = provider;
    }

    @Override
    public Assignment mapFieldSet(FieldSet fieldSet) {
        Assignment result = new Assignment();
        this.errorMessages = new ArrayList();
        result.setErrorMessages(this.errorMessages);
        result.setModifyDate(new Timestamp(System.currentTimeMillis()));
        result.setUuid(UUID.randomUUID());
        result.setPackageProvider(this.provider);
        result.setRecType(fieldSet.readString("RecType"));
        result.setMszUuid(this.setNotEmptyUUID(fieldSet, "LMSZID"));
        result.setLocalUuid(this.setNotEmptyUUID(fieldSet, "categoryID"));
        if (!fieldSet.readString("assignmentFactUuid").isEmpty()) {
            result.setAssignmentFactUuid(this.setUUID(fieldSet, "assignmentFactUuid"));
        }
        result.setOsz(new Participant(this.setNotNullParticipantCode(fieldSet, "ONMSZCode")));
        if (!fieldSet.readString("LMSZProviderCode").isEmpty()) {
            result.setLmszProviderCode(new Participant(this.setParticipantCode(fieldSet, "LMSZProviderCode")));
        }
        if (!fieldSet.readString("providerCode").isEmpty()) {
            result.setProviderCode(new Participant(this.setParticipantCode(fieldSet, "providerCode")));
        }
        result.setRecipient(this.mapRecipientFieldSet(fieldSet));
        this.mapReasonBasisPersonFieldSet(fieldSet).ifPresent(r -> result.getBasisPersons().add((BasisPerson)r));
        result.setDecisionDate(this.setNotEmptyDate(fieldSet, "decision_date"));
        result.setBeginDate(this.setNotEmptyDate(fieldSet, "dateStart"));
        if (!fieldSet.readString("dateFinish").isEmpty()) {
            result.setEndDate(this.setDate(fieldSet, "dateFinish"));
        }
        result.setCriteriaUsing(this.setBoolean(fieldSet, "usingSign"));
        result.setNeedCriteria(this.setCriteria(fieldSet, "criteria"));
        Optional<NeedsCriteria> needsCriteria = this.mapNeedsCriteriaFieldSet(fieldSet, result.getRecType());
        needsCriteria.ifPresent(criteria -> result.getNeedsCriteriaList().add((NeedsCriteria)criteria));
        if (this.isNotEmpty(fieldSet, "FormCode")) {
            result.setGrantingForm(new FormOfGranting(fieldSet.readString("FormCode")));
        }
        result.setQuantity(this.setAmount(fieldSet, "amount"));
        if (ALTERNATION_BASED_ON_PREVIOUS_ERRORS.equals(result.getRecType())) {
            this.isNotEmpty(fieldSet, "measuryCode");
        }
        result.setMeasureUnit(new UnitsOfMeasure(this.setMeasuryCode(fieldSet, "measuryCode")));
        result.setMonetization(this.setBoolean(fieldSet, "monetization"));
        result.setDescription(this.setString200(fieldSet, "content"));
        result.setComment(this.setString200(fieldSet, "comment"));
        if (ALTERNATION_BASED_ON_PREVIOUS_ERRORS.equals(result.getRecType())) {
            this.isNotEmpty(fieldSet, "equivalentAmount");
        }
        if (!fieldSet.readString("equivalentAmount").isEmpty()) {
            result.setEquivalentAmount(this.setAmount(fieldSet, "equivalentAmount"));
        }
        return result;
    }

    private Recipient mapRecipientFieldSet(FieldSet fieldSet) {
        Recipient result = new Recipient();
        result.setSnils(this.setNotEmptySnils(fieldSet, "SNILS_recip"));
        result.setLastName(this.setNotEmptyName(fieldSet, "FamilyName_recip"));
        result.setFirstName(this.setNotEmptyName(fieldSet, "Name_recip"));
        if (!fieldSet.readString("Patronymic_recip").isEmpty()) {
            result.setMiddleName(this.setName(fieldSet, "Patronymic_recip"));
        }
        result.setGender(this.setGender(fieldSet, "Gender_recip"));
        result.setBirthDate(this.setNotEmptyDate(fieldSet, "BirthDate_recip"));
        String docTypeString = fieldSet.readString("doctype_recip");
        if (StringUtils.isNotBlank(docTypeString)) {
            if (docTypeString.length() < 2) {
                docTypeString = "0" + docTypeString;
            }
            result.setDocType(new Identity(docTypeString));
            if (!fieldSet.readString("doc_Series_recip").isEmpty() || FACT.equals(fieldSet.readString("RecType"))) {
                result.setDocSeries(this.setNotEmptyDocSeries(fieldSet, "doc_Series_recip", docTypeString));
            }
            result.setDocNumber(this.setNotEmptyDocNumber(fieldSet, "doc_Number_recip", docTypeString));
            result.setDocIssueDate(this.setNotEmptyDate(fieldSet, "doc_IssueDate_recip"));
            result.setDocAuthority(this.setNotEmptyIssuer(fieldSet, "doc_Issuer_recip"));
        }
        return result;
    }

    private Optional<Recipient> mapReasonFieldSet(FieldSet fieldSet) {
        Recipient result = new Recipient();
        if (!fieldSet.readString("SNILS_reason").isEmpty()) {
            result.setSnils(this.setSnils(fieldSet, "SNILS_reason"));
        }
        if (!StringUtils.isNotBlank(result.getSnils())) {
            return Optional.empty();
        }
        result.setLastName(this.setNotEmptyName(fieldSet, "FamilyName_reason"));
        result.setFirstName(this.setNotEmptyName(fieldSet, "Name_reason"));
        if (!fieldSet.readString("Patronymic_reason").isEmpty()) {
            result.setMiddleName(this.setName(fieldSet, "Patronymic_reason"));
        }
        result.setGender(this.setGender(fieldSet, "Gender_reason"));
        result.setBirthDate(this.setNotEmptyDate(fieldSet, "BirthDate_reason"));
        String docTypeString = fieldSet.readString("doctype_reason");
        if (StringUtils.isNotBlank(docTypeString)) {
            if (docTypeString.length() < 2) {
                docTypeString = "0" + docTypeString;
            }
            result.setDocType(new Identity(docTypeString));
            result.setDocSeries(this.setNotEmptyDocSeries(fieldSet, "doc_Series_reason", docTypeString));
            result.setDocNumber(this.setNotEmptyDocNumber(fieldSet, "doc_Number_reason", docTypeString));
            result.setDocIssueDate(this.setNotEmptyDate(fieldSet, "doc_IssueDate_reason"));
            result.setDocAuthority(this.setNotEmptyIssuer(fieldSet, "doc_Issuer_reason"));
        }
        return Optional.of(result);
    }

    private Optional<BasisPerson> mapReasonBasisPersonFieldSet(FieldSet fieldSet) {
        BasisPerson result = new BasisPerson();
        String kinshipTypeCode = fieldSet.readString("kinshipTypeCode");
        result.setKinshipTypeCode(kinshipTypeCode.isEmpty() ? null : kinshipTypeCode);
        result.setPrsnInfo(this.mapReasonFieldSet(fieldSet).orElse(null));
        return result.getPrsnInfo() != null ? Optional.of(result) : Optional.empty();
    }

    private Optional<NeedsCriteria> mapNeedsCriteriaFieldSet(FieldSet fieldSet, String recType) {
        NeedsCriteria result = new NeedsCriteria();
        result.setCode(fieldSet.readString("criteriaCode"));
        if (!StringUtils.isNotBlank(result.getCode())) {
            return Optional.empty();
        }
        return Optional.of(result);
    }
}

