/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv;

import java.io.InputStream;
import java.util.HashMap;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.mapping.PatternMatchingCompositeLineMapper;
import org.springframework.batch.item.file.transform.LineTokenizer;
import org.springframework.core.io.InputStreamResource;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AlterationBasedOnDeathOrMovingRecalculationMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AlterationBasedOnRecalculationMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentFieldSetConstants;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentFieldSetMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentLineTokenizer;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.InvalidationMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.NeedsCriteriaFiledSetMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.ReasonFiledSetMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.TerminationMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Assignment;

public class AssignmentCSVParser
extends PatternMatchingCompositeLineMapper
implements AssignmentFieldSetConstants {
    private final AssignmentFieldSetMapper assignmentFieldSetMapper;
    private final ReasonFiledSetMapper reasonFiledSetMapper;
    private final NeedsCriteriaFiledSetMapper needsCriteriaFiledSetMapper;
    private final AlterationBasedOnRecalculationMapper alterationBasedOnRecalculationMapper;
    private final AlterationBasedOnDeathOrMovingRecalculationMapper alterationBasedOnDeathOrMovingRecalculationMapper;
    private final TerminationMapper terminationMapper;
    private final InvalidationMapper invalidationMapper;
    private final AssignmentLineTokenizer assignmentLineTokenizer;

    public AssignmentCSVParser(AssignmentFieldSetMapper assignmentFieldSetMapper, ReasonFiledSetMapper reasonFiledSetMapper, NeedsCriteriaFiledSetMapper needsCriteriaFiledSetMapper, AssignmentLineTokenizer assignmentLineTokenizer, AlterationBasedOnRecalculationMapper alterationBasedOnRecalculationMapper, AlterationBasedOnDeathOrMovingRecalculationMapper alterationBasedOnDeathOrMovingRecalculationMapper, TerminationMapper terminationMapper, InvalidationMapper invalidationMapper) {
        this.assignmentFieldSetMapper = assignmentFieldSetMapper;
        this.needsCriteriaFiledSetMapper = needsCriteriaFiledSetMapper;
        this.assignmentLineTokenizer = assignmentLineTokenizer;
        this.reasonFiledSetMapper = reasonFiledSetMapper;
        this.alterationBasedOnRecalculationMapper = alterationBasedOnRecalculationMapper;
        this.alterationBasedOnDeathOrMovingRecalculationMapper = alterationBasedOnDeathOrMovingRecalculationMapper;
        this.terminationMapper = terminationMapper;
        this.invalidationMapper = invalidationMapper;
    }

    private FlatFileItemReader<Assignment> itemReader() {
        FlatFileItemReader<Assignment> itemReader = new FlatFileItemReader<Assignment>();
        itemReader.setEncoding("Windows-1251");
        PatternMatchingCompositeLineMapper mapper = new PatternMatchingCompositeLineMapper();
        HashMap<String, LineTokenizer> tokenizers = new HashMap<String, LineTokenizer>();
        tokenizers.put("Fact*", this.assignmentLineTokenizer);
        tokenizers.put("Reason*", this.assignmentLineTokenizer);
        tokenizers.put("Criteria*", this.assignmentLineTokenizer);
        tokenizers.put("AlterationBasedOnRecalculation*", this.assignmentLineTokenizer);
        tokenizers.put("AlterationBasedOnDeathOrMovingRecalculation*", this.assignmentLineTokenizer);
        tokenizers.put("AlterationBasedOnPreviousErrors*", this.assignmentLineTokenizer);
        tokenizers.put("TerminationBasedOnRecalculation*", this.assignmentLineTokenizer);
        tokenizers.put("TerminationBasedOnIneligibility*", this.assignmentLineTokenizer);
        tokenizers.put("TerminationBasedOnEndOfRight*", this.assignmentLineTokenizer);
        tokenizers.put("TerminationBasedOnEndOfValidityPeriod*", this.assignmentLineTokenizer);
        tokenizers.put("DuplicatesInvalidation*", this.assignmentLineTokenizer);
        tokenizers.put("ErrorsInvalidation*", this.assignmentLineTokenizer);
        mapper.setTokenizers(tokenizers);
        HashMap mappers = new HashMap();
        mappers.put("Fact*", this.assignmentFieldSetMapper);
        mappers.put("Reason*", this.reasonFiledSetMapper);
        mappers.put("Criteria*", this.needsCriteriaFiledSetMapper);
        mappers.put("AlterationBasedOnRecalculation*", this.alterationBasedOnRecalculationMapper);
        mappers.put("AlterationBasedOnDeathOrMovingRecalculation*", this.alterationBasedOnDeathOrMovingRecalculationMapper);
        mappers.put("AlterationBasedOnPreviousErrors*", this.assignmentFieldSetMapper);
        mappers.put("TerminationBasedOnRecalculation*", this.terminationMapper);
        mappers.put("TerminationBasedOnIneligibility*", this.terminationMapper);
        mappers.put("TerminationBasedOnEndOfRight*", this.terminationMapper);
        mappers.put("TerminationBasedOnEndOfValidityPeriod*", this.terminationMapper);
        mappers.put("DuplicatesInvalidation*", this.invalidationMapper);
        mappers.put("ErrorsInvalidation*", this.invalidationMapper);
        mapper.setFieldSetMappers(mappers);
        itemReader.setLineMapper(mapper);
        return itemReader;
    }

    public FlatFileItemReader<Assignment> parse(InputStream inputStream) {
        InputStreamResource resource = new InputStreamResource(inputStream);
        FlatFileItemReader<Assignment> itemReader = this.itemReader();
        itemReader.setLinesToSkip(1);
        itemReader.setResource(resource);
        ExecutionContext context = new ExecutionContext();
        itemReader.open(context);
        return itemReader;
    }
}

