/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.FlatFileItemReader;
import org.springframework.batch.item.file.FlatFileParseException;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.Converter;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AlterationBasedOnDeathOrMovingRecalculationMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AlterationBasedOnRecalculationMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentCSVParser;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentFieldSetMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.AssignmentLineTokenizer;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.InvalidationMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.NeedsCriteriaFiledSetMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.ReasonFiledSetMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.csv.TerminationMapper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Assignment;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Participant;

public class ConverterCSV2XML
implements Converter<InputStream, FlatFileItemReader<Assignment>> {
    private final Log logger = LogFactory.getLog(ConverterCSV2XML.class);
    private final AssignmentCSVParser parser;
    private final Participant participant;

    public ConverterCSV2XML(String participantCode, String[] titleColumns) {
        this.participant = new Participant(participantCode);
        this.parser = new AssignmentCSVParser(new AssignmentFieldSetMapper(this.participant), new ReasonFiledSetMapper(), new NeedsCriteriaFiledSetMapper(), new AssignmentLineTokenizer(titleColumns), new AlterationBasedOnRecalculationMapper(), new AlterationBasedOnDeathOrMovingRecalculationMapper(), new TerminationMapper(), new InvalidationMapper());
    }

    @Override
    public FlatFileItemReader<Assignment> convert(InputStream from) {
        try {
            FlatFileItemReader<Assignment> itemReader = this.parser.parse(from);
            return itemReader;
        }
        catch (FlatFileParseException e) {
            this.logger.error("", e);
            throw new IllegalStateException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u0439\u043b\u0430 \u0432 \u0441\u0442\u0440\u043e\u043a\u0435 " + e.getLineNumber() + " (" + e.getCause().getMessage() + ")", e);
        }
        catch (Exception e) {
            this.logger.error("", e);
            throw new IllegalStateException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0444\u0430\u0439\u043b\u0430", e);
        }
    }
}

