/*
 * Decompiled with CFR 0.152.
 */
package ru.pfrf.egisso.utils.converter.csv2xml.assignment;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.FlatFileItemReader;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.FileHelper;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.ProcessingCallback;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.ConverterCSV2XML;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.model.Assignment;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.converter.xml.AssignmentRegistryHandler;
import ru.pfrf.egisso.utils.converter.csv2xml.assignment.utils.SpaceNormalizedInputStream;

public class Startup {
    private static final Log logger = LogFactory.getLog(Startup.class);
    private static JFrame mainFrame;
    private static final JButton btnStartProcessing;
    private static final JButton btnStopProcessing;
    private static final JPanel buttonPanel;
    private static final JPanel mainPanel;
    private static final JLabel lblProvider;
    private static final JTextField textProvider;
    private static final JLabel lblPath;
    private static final JTextField textSourceFilePath;
    private static final JButton btnSourceFilePath;
    private static final JLabel label;
    private static final JTextField textDestinationFilePath;
    private static final JButton btnDestinationFilePath;
    private static final JProgressBar progressBar;
    private static final JLabel lblProgressLabel;
    private static final JLabel lblProgressValue;
    private static final JPanel journalPanel;
    private static final JLabel lblJournal;
    private static final JScrollPane scrollPane;
    private static final JTextArea journal;
    private static ExecutorService ec;
    private static Future<?> future;

    private static void createAndShowGUI() {
        textDestinationFilePath.setColumns(10);
        String version = Startup.getApplicationVersion();
        mainFrame = new JFrame("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044f CSV \u0444\u0430\u0439\u043b\u043e\u0432");
        mainFrame.setTitle("\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044f CSV \u0444\u0430\u0439\u043b\u043e\u0432" + (version == null ? "" : " v." + version));
        try {
            mainFrame.setIconImage(Startup.loadImage("/images/depersonalization.png"));
        }
        catch (IOException e) {
            throw new IllegalStateException("", e);
        }
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.addWindowListener(new CloseWindowListener());
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{519, 0};
        gridBagLayout.rowHeights = new int[]{105, 360, 51, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        mainFrame.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gbc_mainPanel = new GridBagConstraints();
        gbc_mainPanel.fill = 1;
        gbc_mainPanel.insets = new Insets(0, 0, 5, 0);
        gbc_mainPanel.gridx = 0;
        gbc_mainPanel.gridy = 0;
        mainFrame.getContentPane().add((Component)mainPanel, gbc_mainPanel);
        GridBagLayout gbl_mainPanel = new GridBagLayout();
        gbl_mainPanel.columnWidths = new int[]{0, 0, 0, 0, 0, 0, 0};
        gbl_mainPanel.rowHeights = new int[]{40, 0, 0, 0, 0, 0, 9, 0};
        gbl_mainPanel.columnWeights = new double[]{0.0, 0.0, 1.0, 1.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_mainPanel.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        mainPanel.setLayout(gbl_mainPanel);
        Border emptyBorder = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        mainPanel.setBorder(emptyBorder);
        GridBagConstraints gbc_lblProvider = new GridBagConstraints();
        gbc_lblProvider.anchor = 17;
        gbc_lblProvider.gridwidth = 2;
        gbc_lblProvider.insets = new Insets(0, 0, 5, 5);
        gbc_lblProvider.gridx = 1;
        gbc_lblProvider.gridy = 2;
        mainPanel.add((Component)lblProvider, gbc_lblProvider);
        GridBagConstraints gbc_textProvider = new GridBagConstraints();
        gbc_textProvider.gridwidth = 1;
        gbc_textProvider.insets = new Insets(0, 0, 5, 5);
        gbc_textProvider.fill = 1;
        gbc_textProvider.gridx = 3;
        gbc_textProvider.gridy = 2;
        mainPanel.add((Component)textProvider, gbc_textProvider);
        textProvider.setPreferredSize(new Dimension(10, 25));
        textProvider.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!(textProvider.getText().length() < 4 && (e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyChar() >= 'A' && e.getKeyChar() <= 'H' || e.getKeyChar() >= 'J' && e.getKeyChar() <= 'N' || e.getKeyChar() >= 'P' && e.getKeyChar() <= 'Z'))) {
                    e.consume();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Startup.isFormValid();
                    }
                });
            }
        });
        GridBagConstraints gbc_lblPath = new GridBagConstraints();
        gbc_lblPath.anchor = 16;
        gbc_lblPath.gridwidth = 4;
        gbc_lblPath.insets = new Insets(0, 0, 5, 5);
        gbc_lblPath.gridx = 1;
        gbc_lblPath.gridy = 3;
        mainPanel.add((Component)lblPath, gbc_lblPath);
        GridBagConstraints gbc_textSourceFilePath = new GridBagConstraints();
        gbc_textSourceFilePath.gridwidth = 3;
        gbc_textSourceFilePath.insets = new Insets(0, 0, 5, 5);
        gbc_textSourceFilePath.fill = 1;
        gbc_textSourceFilePath.gridx = 1;
        gbc_textSourceFilePath.gridy = 4;
        mainPanel.add((Component)textSourceFilePath, gbc_textSourceFilePath);
        textSourceFilePath.getDocument().addDocumentListener(new FilePathChangeListener());
        textSourceFilePath.setColumns(1);
        GridBagConstraints gbc_btnDestinationFilePath = new GridBagConstraints();
        gbc_btnDestinationFilePath.fill = 2;
        gbc_btnDestinationFilePath.insets = new Insets(0, 0, 5, 5);
        gbc_btnDestinationFilePath.gridx = 4;
        gbc_btnDestinationFilePath.gridy = 4;
        mainPanel.add((Component)btnSourceFilePath, gbc_btnDestinationFilePath);
        btnSourceFilePath.addActionListener(new SelectFilePathListener(textSourceFilePath));
        GridBagConstraints gbc_label = new GridBagConstraints();
        gbc_label.anchor = 17;
        gbc_label.gridwidth = 4;
        gbc_label.insets = new Insets(0, 0, 5, 5);
        gbc_label.gridx = 1;
        gbc_label.gridy = 5;
        mainPanel.add((Component)label, gbc_label);
        GridBagConstraints gbc_textDestinationFilePath = new GridBagConstraints();
        gbc_textDestinationFilePath.gridwidth = 3;
        gbc_textDestinationFilePath.insets = new Insets(0, 0, 5, 5);
        gbc_textDestinationFilePath.fill = 1;
        gbc_textDestinationFilePath.gridx = 1;
        gbc_textDestinationFilePath.gridy = 6;
        textDestinationFilePath.getDocument().addDocumentListener(new FilePathChangeListener());
        textDestinationFilePath.setColumns(1);
        mainPanel.add((Component)textDestinationFilePath, gbc_textDestinationFilePath);
        GridBagConstraints gbc_btnDestinationFilePath1 = new GridBagConstraints();
        gbc_btnDestinationFilePath1.fill = 2;
        gbc_btnDestinationFilePath1.insets = new Insets(0, 0, 5, 5);
        gbc_btnDestinationFilePath1.gridx = 4;
        gbc_btnDestinationFilePath1.gridy = 6;
        mainPanel.add((Component)btnDestinationFilePath, gbc_btnDestinationFilePath1);
        btnDestinationFilePath.addActionListener(new SelectFilePathListener(textDestinationFilePath));
        GridBagConstraints gbc_lblProgressLabel = new GridBagConstraints();
        gbc_lblProgressLabel.anchor = 16;
        gbc_lblProgressLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblProgressLabel.gridx = 1;
        gbc_lblProgressLabel.gridy = 7;
        mainPanel.add((Component)lblProgressLabel, gbc_lblProgressLabel);
        GridBagConstraints gbc_lblProgressValue = new GridBagConstraints();
        gbc_lblProgressValue.gridwidth = 3;
        gbc_lblProgressValue.anchor = 17;
        gbc_lblProgressValue.insets = new Insets(0, 0, 5, 5);
        gbc_lblProgressValue.gridx = 2;
        gbc_lblProgressValue.gridy = 7;
        mainPanel.add((Component)lblProgressValue, gbc_lblProgressValue);
        GridBagConstraints gbc_progressBar = new GridBagConstraints();
        gbc_progressBar.gridwidth = 4;
        gbc_progressBar.fill = 2;
        gbc_progressBar.insets = new Insets(0, 0, 0, 5);
        gbc_progressBar.gridx = 1;
        gbc_progressBar.gridy = 8;
        mainPanel.add((Component)progressBar, gbc_progressBar);
        GridBagConstraints gbc_journalPanel = new GridBagConstraints();
        gbc_journalPanel.insets = new Insets(0, 0, 5, 0);
        gbc_journalPanel.fill = 1;
        gbc_journalPanel.gridx = 0;
        gbc_journalPanel.gridy = 1;
        mainFrame.getContentPane().add((Component)journalPanel, gbc_journalPanel);
        GridBagLayout gbl_journalPanel = new GridBagLayout();
        gbl_journalPanel.columnWidths = new int[]{0, 0, 0, 0};
        gbl_journalPanel.rowHeights = new int[]{17, 349, 0};
        gbl_journalPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_journalPanel.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        journalPanel.setLayout(gbl_journalPanel);
        GridBagConstraints gbc_lblJournal = new GridBagConstraints();
        gbc_lblJournal.anchor = 17;
        gbc_lblJournal.insets = new Insets(0, 0, 5, 5);
        gbc_lblJournal.gridx = 1;
        gbc_lblJournal.gridy = 0;
        journalPanel.add((Component)lblJournal, gbc_lblJournal);
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.insets = new Insets(0, 0, 0, 5);
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 1;
        gbc_scrollPane.gridy = 1;
        journalPanel.add((Component)scrollPane, gbc_scrollPane);
        journalPanel.setBorder(emptyBorder);
        journal.setEditable(false);
        scrollPane.setViewportView(journal);
        GridBagConstraints gbc_buttonPanel = new GridBagConstraints();
        gbc_buttonPanel.fill = 1;
        gbc_buttonPanel.gridx = 0;
        gbc_buttonPanel.gridy = 2;
        mainFrame.getContentPane().add((Component)buttonPanel, gbc_buttonPanel);
        btnStartProcessing.addActionListener(new StartProcessingListener());
        btnStartProcessing.setEnabled(false);
        buttonPanel.add(btnStartProcessing);
        btnStopProcessing.addActionListener(new StopProcessingListener());
        btnStopProcessing.setEnabled(false);
        buttonPanel.add(btnStopProcessing);
        mainFrame.pack();
        mainFrame.setVisible(true);
        Startup.isFormValid();
    }

    private static Image loadImage(String resource) throws IOException {
        return ImageIO.read(Startup.class.getResourceAsStream(resource));
    }

    private static String getApplicationVersion() {
        return Startup.class.getPackage().getImplementationVersion();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> Startup.createAndShowGUI());
    }

    private static boolean isProviderCodeValid() {
        String text = textProvider.getText();
        return text != null && text.length() == 4 && text.matches("[A-HJ-NP-Z0-9]+");
    }

    private static boolean isSourceFolderValid() {
        try {
            File file = new File(textSourceFilePath.getText());
            if (file.isDirectory() && file.canRead()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static boolean isDestFolderValid() {
        try {
            File file = new File(textDestinationFilePath.getText());
            if (file.isDirectory() && file.canRead()) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static boolean isFormValid() {
        btnStartProcessing.setEnabled(false);
        if (!Startup.isProviderCodeValid()) {
            return false;
        }
        if (!Startup.isSourceFolderValid()) {
            return false;
        }
        if (!Startup.isDestFolderValid()) {
            return false;
        }
        if (Startup.isSameSourceAndDestination()) {
            return false;
        }
        btnStartProcessing.setEnabled(true);
        return true;
    }

    private static boolean isSameSourceAndDestination() {
        try {
            return textSourceFilePath.getText().trim().equals(textDestinationFilePath.getText().trim());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String buildFileName(int i, int fileCount, String providerCode) {
        return providerCode + "_10.06.S_" + String.format("%0" + Math.max(String.valueOf(fileCount).length(), 3) + "d", i) + ".xml";
    }

    static {
        btnStartProcessing = new JButton("\u0417\u0430\u043f\u0443\u0441\u043a");
        btnStopProcessing = new JButton("\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c");
        buttonPanel = new JPanel();
        mainPanel = new JPanel();
        lblProvider = new JLabel("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043a\u043e\u0434 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0434\u0430\u043d\u043d\u044b\u0445:");
        textProvider = new JTextField(7);
        lblPath = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 \u0441 \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u043c\u0438 CSV \u0444\u0430\u0439\u043b\u0430\u043c\u0438:");
        textSourceFilePath = new JTextField();
        btnSourceFilePath = new JButton("...");
        label = new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043f\u0430\u043f\u043a\u0443 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f XML \u0444\u0430\u0439\u043b\u043e\u0432:");
        textDestinationFilePath = new JTextField();
        btnDestinationFilePath = new JButton("...");
        progressBar = new JProgressBar();
        lblProgressLabel = new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e \u0444\u0430\u0439\u043b\u043e\u0432:");
        lblProgressValue = new JLabel("0 \u0438\u0437 0");
        journalPanel = new JPanel();
        lblJournal = new JLabel("\u0416\u0443\u0440\u043d\u0430\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438:");
        scrollPane = new JScrollPane();
        journal = new JTextArea();
        ec = Executors.newSingleThreadExecutor();
    }

    private static class CSV2XMLHandler
    implements Runnable,
    ProcessingCallback {
        private String providerCode;
        private final String sourceFolder;
        private final String destinationFolder;
        private int fileCount;
        private int errorCount;
        private List<String> errorMessages;
        private String runTime;

        CSV2XMLHandler(String providerCode, String sourceFolder, String destinationFolder) {
            this.providerCode = providerCode;
            this.sourceFolder = sourceFolder;
            this.destinationFolder = destinationFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.runTime = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            try {
                List<File> files;
                block14: {
                    journal.setText("");
                    this.updateUI(false);
                    File sourceFile = new File(this.sourceFolder);
                    FileHelper fileHelper = new FileHelper();
                    files = fileHelper.getFiles(sourceFile);
                    if (files.size() != 0) break block14;
                    this.dirWithoutFiles();
                    return;
                }
                try {
                    this.setTotalFilesCount(files.size());
                    for (int i = 0; i < files.size(); ++i) {
                        if (this.isCancelled()) {
                            logger.info("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430.");
                            break;
                        }
                        try {
                            journal.append("csv-\u0444\u0430\u0439\u043b, \u0438\u0437 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0431\u0435\u0440\u0443\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u044b\u0435: " + files.get(i).getName() + "\r\n");
                            this.startProcessing(i, files.get(i));
                            this.processFile(i + 1, files.get(i), new File(this.destinationFolder));
                            continue;
                        }
                        catch (Exception e) {
                            this.errorProcessing(i + 1, files.get(i), e);
                            continue;
                        }
                        finally {
                            this.endProcessing(i + 1, files.get(i), Startup.buildFileName(i, this.fileCount, this.providerCode));
                        }
                    }
                }
                catch (Throwable e) {
                    journal.append(e.getMessage());
                }
            }
            finally {
                this.updateUI(true);
                future = null;
            }
        }

        private void processFile(int i, File file, File destinationFolder) {
            String dstFileName = Startup.buildFileName(i, this.fileCount, this.providerCode);
            File destinationFile = new File(destinationFolder, dstFileName);
            try (FileInputStream is = FileUtils.openInputStream(file);
                 FileOutputStream os = FileUtils.openOutputStream(destinationFile);
                 BufferedReader br = new BufferedReader(new FileReader(file));){
                String[] titleColumns = br.readLine().split(";");
                ConverterCSV2XML converter = new ConverterCSV2XML(this.providerCode, titleColumns);
                FlatFileItemReader<Assignment> itemReader = converter.convert(new SpaceNormalizedInputStream(is));
                AssignmentRegistryHandler handler = new AssignmentRegistryHandler(this.errorMessages);
                handler.marshall(itemReader, (OutputStream)os);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            finally {
                if (this.errorMessages.size() > 0) {
                    try {
                        FileUtils.forceDelete(destinationFile);
                        journal.append("xml-\u0444\u0430\u0439\u043b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\r\n");
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430 " + destinationFile, e);
                    }
                } else {
                    journal.append("xml-\u0444\u0430\u0439\u043b, \u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0432\u0435\u0434\u0435\u0442\u0441\u044f \u0437\u0430\u043f\u0438\u0441\u044c: " + dstFileName + "\r\n");
                }
            }
        }

        public static void main(String[] args) {
            if (args.length != 2) {
                System.err.println("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043a\u043e\u043c\u0430\u043d\u0434\u043d\u043e\u0439 \u0441\u0442\u0440\u043e\u043a\u0438:");
                System.err.println("1-\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 - \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438");
                System.err.println("2-\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 - \u043f\u0443\u0442\u044c \u043a \u043f\u0430\u043f\u043a\u0435, \u043a\u0443\u0434\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442");
                return;
            }
            new CSV2XMLHandler("", "", "").processFile(0, new File(args[0]), new File(args[1]));
        }

        private void updateProgress(int current) {
            String progressMsg = this.errorCount == 0 && current < this.fileCount ? String.format("%d \u0438\u0437 %d", current, this.fileCount) : String.format("\u0443\u0441\u043f\u0435\u0448\u043d\u043e %d, c \u043e\u0448\u0438\u0431\u043a\u0430\u043c\u0438 %d, \u0432\u0441\u0435\u0433\u043e %d", current - this.errorCount, this.errorCount, this.fileCount);
            lblProgressValue.setText(progressMsg);
            progressBar.setMaximum(this.fileCount);
            progressBar.setValue(current);
        }

        private void updateUI(boolean enabled) {
            btnStartProcessing.setEnabled(enabled);
            btnStopProcessing.setEnabled(!enabled);
            btnSourceFilePath.setEnabled(enabled);
            textSourceFilePath.setEnabled(enabled);
            btnDestinationFilePath.setEnabled(enabled);
            textDestinationFilePath.setEnabled(enabled);
        }

        @Override
        public void setTotalFilesCount(int fileCount) {
            this.fileCount = fileCount;
        }

        @Override
        public void startProcessing(int index, File file) {
            String journalMsg = "\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0447\u0430\u0442\u043e " + new SimpleDateFormat("dd.MM.yyyy HH:mm").format(new Date()) + "\r\n";
            journal.append(journalMsg);
            this.errorMessages = new ArrayList<String>();
        }

        @Override
        public void endProcessing(int index, File sourceFile, String dstFile) {
            this.writeProtocolAndJournal(String.valueOf(index), sourceFile, dstFile);
            this.updateProgress(index);
        }

        @Override
        public void errorProcessing(int index, File file, Throwable e) {
            if (e instanceof FileNotFoundException) {
                this.errorMessages.add("\u0424\u0430\u0439\u043b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            } else {
                this.errorMessages.add(e.getMessage());
            }
        }

        @Override
        public void dirWithoutFiles() {
            lblProgressValue.setText("\u041f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0445 \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
            progressBar.setMaximum(this.fileCount);
            progressBar.setValue(0);
        }

        @Override
        public boolean isCancelled() {
            return future != null && future.isCancelled();
        }

        private void writeProtocolAndJournal(String index, File sourceFile, String dstFile) {
            ArrayList<String> protocolList = new ArrayList<String>();
            String date = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
            if (this.errorMessages.size() > 0) {
                ++this.errorCount;
                this.errorMessages.forEach(violation -> {
                    journal.append(violation + "\n");
                    protocolList.add(String.format("%s_%s;\u041e\u0428\u0418\u0411\u041a\u0410;%s;\"%s\"", date, index, sourceFile.getName(), violation));
                });
            } else {
                journal.append(String.format("%s_%s : \u0423\u0421\u041f\u0415\u0428\u041d\u041e\n", date, index));
                protocolList.add(String.format("%s_%s;\u0423\u0421\u041f\u0415\u0428\u041d\u041e;%s;%s", date, index, sourceFile.getName(), dstFile));
            }
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.runTime + "_" + this.providerCode + "_popdlog.csv", true)));
                protocolList.forEach(protocol -> out.println((String)protocol));
                out.close();
            }
            catch (IOException e) {
                System.out.println("writer:" + e);
            }
        }
    }

    private static class CloseWindowListener
    extends WindowAdapter {
        private CloseWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (future != null && !future.isDone() && !future.isCancelled()) {
                if (JOptionPane.showConfirmDialog(mainFrame, "\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 CSV \u0444\u0430\u0439\u043b\u043e\u0432 \u043d\u0435 \u0437\u0430\u0432\u0435\u0448\u0451\u043d", "\u0425\u043e\u0442\u0438\u0442\u0435 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c?", 0, 3) == 0) {
                    System.exit(0);
                }
            } else {
                System.exit(0);
            }
        }
    }

    private static class StopProcessingListener
    implements ActionListener {
        private StopProcessingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (future != null) {
                future.cancel(true);
            }
        }
    }

    private static class StartProcessingListener
    implements ActionListener {
        private StartProcessingListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Startup.isFormValid()) {
                future = ec.submit(new CSV2XMLHandler(textProvider.getText(), textSourceFilePath.getText(), textDestinationFilePath.getText()));
            }
        }
    }

    private static class FilePathChangeListener
    implements DocumentListener {
        private FilePathChangeListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.onChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.onChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.onChange();
        }

        void onChange() {
            Startup.isFormValid();
        }
    }

    private static class SelectFilePathListener
    implements ActionListener {
        private final JTextField field;

        public SelectFilePathListener(JTextField field) {
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            String filePath = this.field.getText();
            fileChooser.setCurrentDirectory(new File(filePath.isEmpty() ? "." : filePath));
            fileChooser.setDialogTitle("\u0412\u044b\u0431\u043e\u0440 \u043f\u0430\u043f\u043a\u0438");
            fileChooser.setFileSelectionMode(1);
            fileChooser.setAcceptAllFileFilterUsed(false);
            if (fileChooser.showOpenDialog(mainFrame) == 0) {
                String path = fileChooser.getSelectedFile().toString();
                this.field.setText(path);
                this.field.requestFocus();
                this.field.select(0, path.length());
            }
        }
    }
}

