/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.lang.Nullable;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;

public class CompositeTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    private final TransactionAttributeSource[] transactionAttributeSources;

    public CompositeTransactionAttributeSource(TransactionAttributeSource[] transactionAttributeSources) {
        Assert.notNull((Object)transactionAttributeSources, "TransactionAttributeSource array must not be null");
        this.transactionAttributeSources = transactionAttributeSources;
    }

    public final TransactionAttributeSource[] getTransactionAttributeSources() {
        return this.transactionAttributeSources;
    }

    @Override
    @Nullable
    public TransactionAttribute getTransactionAttribute(Method method, @Nullable Class<?> targetClass) {
        for (TransactionAttributeSource tas : this.transactionAttributeSources) {
            TransactionAttribute ta = tas.getTransactionAttribute(method, targetClass);
            if (ta == null) continue;
            return ta;
        }
        return null;
    }
}

