/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.classify.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.aop.support.AopUtils;
import org.springframework.classify.util.MethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class AnnotationMethodResolver
implements MethodResolver {
    private Class<? extends Annotation> annotationType;

    public AnnotationMethodResolver(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "annotationType must not be null");
        Assert.isTrue(ObjectUtils.containsElement((Object[])annotationType.getAnnotation(Target.class).value(), (Object)ElementType.METHOD), "Annotation [" + annotationType + "] is not a Method-level annotation.");
        this.annotationType = annotationType;
    }

    @Override
    public Method findMethod(Object candidate) {
        Assert.notNull(candidate, "candidate object must not be null");
        Class<?> targetClass = AopUtils.getTargetClass(candidate);
        if (targetClass == null) {
            targetClass = candidate.getClass();
        }
        return this.findMethod(targetClass);
    }

    @Override
    public Method findMethod(final Class<?> clazz) {
        Assert.notNull(clazz, "class must not be null");
        final AtomicReference annotatedMethod = new AtomicReference();
        ReflectionUtils.doWithMethods(clazz, new ReflectionUtils.MethodCallback(){

            @Override
            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Object annotation2 = AnnotationUtils.findAnnotation(method, AnnotationMethodResolver.this.annotationType);
                if (annotation2 != null) {
                    Assert.isNull(annotatedMethod.get(), "found more than one method on target class [" + clazz + "] with the annotation type [" + AnnotationMethodResolver.this.annotationType + "]");
                    annotatedMethod.set(method);
                }
            }
        });
        return (Method)annotatedMethod.get();
    }
}

