/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.annotation;

import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.wiring.BeanWiringInfo;
import org.springframework.beans.factory.wiring.BeanWiringInfoResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class AnnotationBeanWiringInfoResolver
implements BeanWiringInfoResolver {
    @Override
    @Nullable
    public BeanWiringInfo resolveWiringInfo(Object beanInstance) {
        Assert.notNull(beanInstance, "Bean instance must not be null");
        Configurable annotation2 = beanInstance.getClass().getAnnotation(Configurable.class);
        return annotation2 != null ? this.buildWiringInfo(beanInstance, annotation2) : null;
    }

    protected BeanWiringInfo buildWiringInfo(Object beanInstance, Configurable annotation2) {
        if (!Autowire.NO.equals((Object)annotation2.autowire())) {
            return new BeanWiringInfo(annotation2.autowire().value(), annotation2.dependencyCheck());
        }
        if (!"".equals(annotation2.value())) {
            return new BeanWiringInfo(annotation2.value(), false);
        }
        return new BeanWiringInfo(this.getDefaultBeanName(beanInstance), true);
    }

    protected String getDefaultBeanName(Object beanInstance) {
        return ClassUtils.getUserClass(beanInstance).getName();
    }
}

