/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.util.Assert;

public class RepeatOperationsInterceptor
implements MethodInterceptor {
    private RepeatOperations repeatOperations = new RepeatTemplate();

    public void setRepeatOperations(RepeatOperations batchTempate) {
        Assert.notNull((Object)batchTempate, "'repeatOperations' cannot be null.");
        this.repeatOperations = batchTempate;
    }

    @Override
    public Object invoke(final MethodInvocation invocation) throws Throwable {
        final ResultHolder result = new ResultHolder();
        final boolean voidReturnType = Void.TYPE.equals(invocation.getMethod().getReturnType());
        if (voidReturnType) {
            result.setValue(new Object());
        }
        this.repeatOperations.iterate(new RepeatCallback(){

            @Override
            public RepeatStatus doInIteration(RepeatContext context) throws Exception {
                try {
                    MethodInvocation clone = invocation;
                    if (!(invocation instanceof ProxyMethodInvocation)) {
                        throw new IllegalStateException("MethodInvocation of the wrong type detected - this should not happen with Spring AOP, so please raise an issue if you see this exception");
                    }
                    clone = ((ProxyMethodInvocation)invocation).invocableClone();
                    Object value = clone.proceed();
                    if (voidReturnType) {
                        return RepeatStatus.CONTINUABLE;
                    }
                    if (!RepeatOperationsInterceptor.this.isComplete(value)) {
                        result.setValue(value);
                        return RepeatStatus.CONTINUABLE;
                    }
                    result.setFinalValue(value);
                    return RepeatStatus.FINISHED;
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new RepeatOperationsInterceptorException("Unexpected error in batch interceptor", e);
                }
            }
        });
        if (result.isReady()) {
            return result.getValue();
        }
        throw new IllegalStateException("No result available for attempted repeat call to " + invocation + ".  The invocation was never called, so maybe there is a problem with the completion policy?");
    }

    private boolean isComplete(Object result) {
        return result == null || result instanceof Boolean && (Boolean)result == false;
    }

    private static class ResultHolder {
        private Object value = null;
        private boolean ready = false;

        private ResultHolder() {
        }

        public void setValue(Object value) {
            this.ready = true;
            this.value = value;
        }

        public void setFinalValue(Object value) {
            if (this.ready) {
                return;
            }
            this.setValue(value);
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isReady() {
            return this.ready;
        }
    }

    private static class RepeatOperationsInterceptorException
    extends RepeatException {
        public RepeatOperationsInterceptorException(String message, Throwable e) {
            super(message, e);
        }
    }
}

