/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.context;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.util.Assert;

public class RepeatContextCounter {
    private final String countKey;
    private final boolean useParent;
    private final RepeatContext context;

    public final void increment(int delta) {
        AtomicInteger count = this.getCounter();
        count.addAndGet(delta);
    }

    public final void increment() {
        this.increment(1);
    }

    public RepeatContextCounter(RepeatContext context, String countKey) {
        this(context, countKey, false);
    }

    public RepeatContextCounter(RepeatContext context, String countKey, boolean useParent) {
        Assert.notNull((Object)context, "The context must be provided to initialize a counter");
        this.countKey = countKey;
        this.useParent = useParent;
        RepeatContext parent = context.getParent();
        this.context = this.useParent && parent != null ? parent : context;
        if (!this.context.hasAttribute(countKey)) {
            this.context.setAttribute(countKey, new AtomicInteger());
        }
    }

    public int getCount() {
        return this.getCounter().intValue();
    }

    private AtomicInteger getCounter() {
        return (AtomicInteger)this.context.getAttribute(this.countKey);
    }
}

