/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml.stax;

import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.springframework.batch.item.xml.stax.AbstractEventReaderWrapper;
import org.springframework.batch.item.xml.stax.FragmentEventReader;
import org.springframework.dao.DataAccessResourceFailureException;

public class DefaultFragmentEventReader
extends AbstractEventReaderWrapper
implements FragmentEventReader {
    private boolean startFragmentFollows = false;
    private boolean endFragmentFollows = false;
    private boolean insideFragment = false;
    private boolean fakeDocumentEnd = false;
    private StartDocument startDocumentEvent = null;
    private EndDocument endDocumentEvent = null;
    private QName fragmentRootName = null;
    private int matchCounter = 0;

    public DefaultFragmentEventReader(XMLEventReader wrappedEventReader) {
        super(wrappedEventReader);
        try {
            this.startDocumentEvent = (StartDocument)wrappedEventReader.peek();
        }
        catch (XMLStreamException e) {
            throw new DataAccessResourceFailureException("Error reading start document from event reader", e);
        }
        this.endDocumentEvent = XMLEventFactory.newInstance().createEndDocument();
    }

    @Override
    public void markStartFragment() {
        this.startFragmentFollows = true;
        this.fragmentRootName = null;
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.peek() != null) {
                return true;
            }
        }
        catch (XMLStreamException e) {
            throw new DataAccessResourceFailureException("Error reading XML stream", e);
        }
        return false;
    }

    @Override
    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            throw new DataAccessResourceFailureException("Error reading XML stream", e);
        }
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        if (this.fakeDocumentEnd) {
            throw new NoSuchElementException();
        }
        XMLEvent event = this.wrappedEventReader.peek();
        XMLEvent proxyEvent = this.alterEvent(event, false);
        this.checkFragmentEnd(proxyEvent);
        if (event == proxyEvent) {
            this.wrappedEventReader.nextEvent();
        }
        return proxyEvent;
    }

    private void checkFragmentEnd(XMLEvent event) {
        if (event.isStartElement() && ((StartElement)event).getName().equals(this.fragmentRootName)) {
            ++this.matchCounter;
        } else if (event.isEndElement() && ((EndElement)event).getName().equals(this.fragmentRootName)) {
            --this.matchCounter;
            if (this.matchCounter == 0) {
                this.endFragmentFollows = true;
            }
        }
    }

    private XMLEvent alterEvent(XMLEvent event, boolean peek) {
        if (this.startFragmentFollows) {
            this.fragmentRootName = ((StartElement)event).getName();
            if (!peek) {
                this.startFragmentFollows = false;
                this.insideFragment = true;
            }
            return this.startDocumentEvent;
        }
        if (this.endFragmentFollows) {
            if (!peek) {
                this.endFragmentFollows = false;
                this.insideFragment = false;
                this.fakeDocumentEnd = true;
            }
            return this.endDocumentEvent;
        }
        return event;
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        if (this.fakeDocumentEnd) {
            return null;
        }
        return this.alterEvent(this.wrappedEventReader.peek(), true);
    }

    @Override
    public void markFragmentProcessed() {
        if (this.insideFragment || this.startFragmentFollows) {
            try {
                while (!(this.nextEvent() instanceof EndDocument)) {
                }
            }
            catch (XMLStreamException e) {
                throw new DataAccessResourceFailureException("Error reading XML stream", e);
            }
        }
        this.fakeDocumentEnd = false;
    }

    @Override
    public void reset() {
        this.insideFragment = false;
        this.startFragmentFollows = false;
        this.endFragmentFollows = false;
        this.fakeDocumentEnd = false;
        this.fragmentRootName = null;
        this.matchCounter = 0;
    }
}

