/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.xml.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.xml.StaxEventItemReader;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StaxEventItemReaderBuilder<T> {
    private boolean strict = true;
    private Resource resource;
    private Unmarshaller unmarshaller;
    private List<String> fragmentRootElements = new ArrayList<String>();
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public StaxEventItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public StaxEventItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public StaxEventItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public StaxEventItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public StaxEventItemReaderBuilder<T> resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    public StaxEventItemReaderBuilder<T> unmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
        return this;
    }

    public StaxEventItemReaderBuilder<T> addFragmentRootElements(String ... fragmentRootElements) {
        this.fragmentRootElements.addAll(Arrays.asList(fragmentRootElements));
        return this;
    }

    public StaxEventItemReaderBuilder<T> addFragmentRootElements(List<String> fragmentRootElements) {
        this.fragmentRootElements.addAll(fragmentRootElements);
        return this;
    }

    public StaxEventItemReaderBuilder<T> strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public StaxEventItemReader<T> build() {
        Assert.notNull((Object)this.resource, "A resource is required.");
        StaxEventItemReader reader = new StaxEventItemReader();
        if (this.saveState) {
            Assert.state(StringUtils.hasText(this.name), "A name is required when saveState is set to true.");
        } else {
            reader.setName(this.name);
        }
        Assert.notEmpty(this.fragmentRootElements, "At least one fragment root element is required");
        reader.setSaveState(this.saveState);
        reader.setResource(this.resource);
        reader.setFragmentRootElementNames(this.fragmentRootElements.toArray(new String[this.fragmentRootElements.size()]));
        reader.setStrict(this.strict);
        reader.setUnmarshaller(this.unmarshaller);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        return reader;
    }
}

