/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.HashMap;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptEvaluator;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.scripting.support.StandardScriptEvaluator;
import org.springframework.scripting.support.StaticScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ScriptItemProcessor<I, O>
implements ItemProcessor<I, O>,
InitializingBean {
    private static final String ITEM_BINDING_VARIABLE_NAME = "item";
    private String language;
    private ScriptSource script;
    private ScriptSource scriptSource;
    private ScriptEvaluator scriptEvaluator;
    private String itemBindingVariableName = "item";

    @Override
    public O process(I item) throws Exception {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(this.itemBindingVariableName, item);
        return (O)this.scriptEvaluator.evaluate(this.getScriptSource(), arguments);
    }

    public void setScript(Resource resource) {
        Assert.notNull((Object)resource, "The script resource cannot be null");
        this.script = new ResourceScriptSource(resource);
    }

    public void setScriptSource(String scriptSource, String language) {
        Assert.hasText(language, "Language must contain the script language");
        Assert.hasText(scriptSource, "Script source must contain the script source to evaluate");
        this.language = language;
        this.scriptSource = new StaticScriptSource(scriptSource);
    }

    public void setItemBindingVariableName(String itemBindingVariableName) {
        this.itemBindingVariableName = itemBindingVariableName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.scriptEvaluator = new StandardScriptEvaluator();
        Assert.state(this.scriptSource != null || this.script != null, "Either the script source or script file must be provided");
        Assert.state(this.scriptSource == null || this.script == null, "Either a script source or script file must be provided, not both");
        if (this.scriptSource != null) {
            Assert.isTrue(!StringUtils.isEmpty(this.language), "Language must be provided when using script source");
            ((StandardScriptEvaluator)this.scriptEvaluator).setLanguage(this.language);
        }
    }

    private ScriptSource getScriptSource() {
        if (this.script != null) {
            return this.script;
        }
        if (this.scriptSource != null) {
            return this.scriptSource;
        }
        throw new IllegalStateException("Either a script source or script needs to be provided.");
    }
}

