/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.builder;

import java.math.BigInteger;
import javax.sql.DataSource;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.item.database.support.ColumnMapItemPreparedStatementSetter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;

public class JdbcBatchItemWriterBuilder<T> {
    private boolean assertUpdates = true;
    private String sql;
    private ItemPreparedStatementSetter<T> itemPreparedStatementSetter;
    private ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider;
    private DataSource dataSource;
    private NamedParameterJdbcOperations namedParameterJdbcTemplate;
    private BigInteger mapped = new BigInteger("0");

    public JdbcBatchItemWriterBuilder<T> dataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> assertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> sql(String sql) {
        this.sql = sql;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> itemPreparedStatementSetter(ItemPreparedStatementSetter<T> itemPreparedStatementSetter) {
        this.itemPreparedStatementSetter = itemPreparedStatementSetter;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> itemSqlParameterSourceProvider(ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider) {
        this.itemSqlParameterSourceProvider = itemSqlParameterSourceProvider;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> namedParametersJdbcTemplate(NamedParameterJdbcOperations namedParameterJdbcOperations) {
        this.namedParameterJdbcTemplate = namedParameterJdbcOperations;
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> columnMapped() {
        this.mapped = this.mapped.setBit(0);
        return this;
    }

    public JdbcBatchItemWriterBuilder<T> beanMapped() {
        this.mapped = this.mapped.setBit(1);
        return this;
    }

    public JdbcBatchItemWriter<T> build() {
        Assert.state(this.dataSource != null || this.namedParameterJdbcTemplate != null, "Either a DataSource or a NamedParameterJdbcTemplate is required");
        Assert.notNull((Object)this.sql, "A SQL statement is required");
        int mappedValue = this.mapped.intValue();
        Assert.state(mappedValue != 3, "Either an item can be mapped via db column or via bean spec, can't be both");
        JdbcBatchItemWriter writer = new JdbcBatchItemWriter();
        writer.setSql(this.sql);
        writer.setAssertUpdates(this.assertUpdates);
        writer.setItemSqlParameterSourceProvider(this.itemSqlParameterSourceProvider);
        writer.setItemPreparedStatementSetter(this.itemPreparedStatementSetter);
        if (mappedValue == 1) {
            writer.setItemPreparedStatementSetter(new ColumnMapItemPreparedStatementSetter());
        } else if (mappedValue == 2) {
            writer.setItemSqlParameterSourceProvider(new BeanPropertyItemSqlParameterSourceProvider());
        }
        if (this.dataSource != null) {
            this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(this.dataSource);
        }
        writer.setJdbcTemplate(this.namedParameterJdbcTemplate);
        return writer;
    }
}

