/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcParameterUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public class JdbcBatchItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(JdbcBatchItemWriter.class);
    private NamedParameterJdbcOperations namedParameterJdbcTemplate;
    private ItemPreparedStatementSetter<T> itemPreparedStatementSetter;
    private ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider;
    private String sql;
    private boolean assertUpdates = true;
    private int parameterCount;
    private boolean usingNamedParameters;

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setItemPreparedStatementSetter(ItemPreparedStatementSetter<T> preparedStatementSetter) {
        this.itemPreparedStatementSetter = preparedStatementSetter;
    }

    public void setItemSqlParameterSourceProvider(ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider) {
        this.itemSqlParameterSourceProvider = itemSqlParameterSourceProvider;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.namedParameterJdbcTemplate == null) {
            this.namedParameterJdbcTemplate = new NamedParameterJdbcTemplate(dataSource);
        }
    }

    public void setJdbcTemplate(NamedParameterJdbcOperations namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.notNull((Object)this.namedParameterJdbcTemplate, "A DataSource or a NamedParameterJdbcTemplate is required.");
        Assert.notNull((Object)this.sql, "An SQL statement is required.");
        ArrayList<String> namedParameters = new ArrayList<String>();
        this.parameterCount = JdbcParameterUtils.countParameterPlaceholders(this.sql, namedParameters);
        if (namedParameters.size() > 0) {
            if (this.parameterCount != namedParameters.size()) {
                throw new InvalidDataAccessApiUsageException("You can't use both named parameters and classic \"?\" placeholders: " + this.sql);
            }
            this.usingNamedParameters = true;
        }
        if (!this.usingNamedParameters) {
            Assert.notNull(this.itemPreparedStatementSetter, "Using SQL statement with '?' placeholders requires an ItemPreparedStatementSetter");
        }
    }

    @Override
    public void write(final List<? extends T> items) throws Exception {
        if (!items.isEmpty()) {
            int[] updateCounts;
            if (logger.isDebugEnabled()) {
                logger.debug("Executing batch with " + items.size() + " items.");
            }
            if (this.usingNamedParameters) {
                if (items.get(0) instanceof Map && this.itemSqlParameterSourceProvider == null) {
                    updateCounts = this.namedParameterJdbcTemplate.batchUpdate(this.sql, items.toArray(new Map[items.size()]));
                } else {
                    SqlParameterSource[] batchArgs = new SqlParameterSource[items.size()];
                    int i = 0;
                    for (Map map : items) {
                        batchArgs[i++] = this.itemSqlParameterSourceProvider.createSqlParameterSource(map);
                    }
                    updateCounts = this.namedParameterJdbcTemplate.batchUpdate(this.sql, batchArgs);
                }
            } else {
                updateCounts = (int[])this.namedParameterJdbcTemplate.getJdbcOperations().execute(this.sql, (PreparedStatementCallback)new PreparedStatementCallback<int[]>(){

                    public int[] doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                        for (Object item : items) {
                            JdbcBatchItemWriter.this.itemPreparedStatementSetter.setValues(item, ps);
                            ps.addBatch();
                        }
                        return ps.executeBatch();
                    }
                });
            }
            if (this.assertUpdates) {
                for (int i = 0; i < updateCounts.length; ++i) {
                    int value = updateCounts[i];
                    if (value != 0) continue;
                    throw new EmptyResultDataAccessException("Item " + i + " of " + updateCounts.length + " did not update any rows: [" + items.get(i) + "]", 1);
                }
            }
        }
    }
}

