/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import java.util.Map;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.batch.item.data.Neo4jItemReader;
import org.springframework.util.Assert;

public class Neo4jItemReaderBuilder<T> {
    private SessionFactory sessionFactory;
    private String startStatement;
    private String returnStatement;
    private String matchStatement;
    private String whereStatement;
    private String orderByStatement;
    private Class<T> targetType;
    private Map<String, Object> parameterValues;
    private int pageSize = 10;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;

    public Neo4jItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public Neo4jItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public Neo4jItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public Neo4jItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public Neo4jItemReaderBuilder<T> sessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        return this;
    }

    public Neo4jItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Neo4jItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public Neo4jItemReaderBuilder<T> startStatement(String startStatement) {
        this.startStatement = startStatement;
        return this;
    }

    public Neo4jItemReaderBuilder<T> returnStatement(String returnStatement) {
        this.returnStatement = returnStatement;
        return this;
    }

    public Neo4jItemReaderBuilder<T> matchStatement(String matchStatement) {
        this.matchStatement = matchStatement;
        return this;
    }

    public Neo4jItemReaderBuilder<T> whereStatement(String whereStatement) {
        this.whereStatement = whereStatement;
        return this;
    }

    public Neo4jItemReaderBuilder<T> orderByStatement(String orderByStatement) {
        this.orderByStatement = orderByStatement;
        return this;
    }

    public Neo4jItemReaderBuilder<T> targetType(Class<T> targetType) {
        this.targetType = targetType;
        return this;
    }

    public Neo4jItemReader<T> build() {
        if (this.saveState) {
            Assert.hasText(this.name, "A name is required when saveState is set to true");
        }
        Assert.notNull((Object)this.sessionFactory, "sessionFactory is required.");
        Assert.notNull(this.targetType, "targetType is required.");
        Assert.hasText(this.startStatement, "startStatement is required.");
        Assert.hasText(this.returnStatement, "returnStatement is required.");
        Assert.hasText(this.orderByStatement, "orderByStatement is required.");
        Assert.isTrue(this.pageSize > 0, "pageSize must be greater than zero");
        Assert.isTrue(this.maxItemCount > 0, "maxItemCount must be greater than zero");
        Assert.isTrue(this.maxItemCount > this.currentItemCount, "maxItemCount must be greater than currentItemCount");
        Neo4jItemReader<T> reader = new Neo4jItemReader<T>();
        reader.setMatchStatement(this.matchStatement);
        reader.setOrderByStatement(this.orderByStatement);
        reader.setPageSize(this.pageSize);
        reader.setParameterValues(this.parameterValues);
        reader.setSessionFactory(this.sessionFactory);
        reader.setTargetType(this.targetType);
        reader.setStartStatement(this.startStatement);
        reader.setReturnStatement(this.returnStatement);
        reader.setWhereStatement(this.whereStatement);
        reader.setName(this.name);
        reader.setSaveState(this.saveState);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        return reader;
    }
}

