/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import java.util.List;
import java.util.Map;
import org.springframework.batch.item.data.MongoItemReader;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoItemReaderBuilder<T> {
    private MongoOperations template;
    private String jsonQuery;
    private Class<? extends T> targetType;
    Map<String, Sort.Direction> sorts;
    private String hint;
    private String fields;
    private String collection;
    private List<Object> parameterValues;
    protected int pageSize = 10;
    private boolean saveState = true;
    private String name;
    private int maxItemCount = Integer.MAX_VALUE;
    private int currentItemCount;
    private Query query;

    public MongoItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public MongoItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public MongoItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public MongoItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    public MongoItemReaderBuilder<T> template(MongoOperations template) {
        this.template = template;
        return this;
    }

    public MongoItemReaderBuilder<T> jsonQuery(String query) {
        this.jsonQuery = query;
        return this;
    }

    public MongoItemReaderBuilder<T> targetType(Class<? extends T> targetType) {
        this.targetType = targetType;
        return this;
    }

    public MongoItemReaderBuilder<T> parameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public MongoItemReaderBuilder<T> fields(String fields) {
        this.fields = fields;
        return this;
    }

    public MongoItemReaderBuilder<T> sorts(Map<String, Sort.Direction> sorts) {
        this.sorts = sorts;
        return this;
    }

    public MongoItemReaderBuilder<T> collection(String collection) {
        this.collection = collection;
        return this;
    }

    public MongoItemReaderBuilder<T> hint(String hint) {
        this.hint = hint;
        return this;
    }

    public MongoItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public MongoItemReaderBuilder<T> query(Query query) {
        this.query = query;
        return this;
    }

    public MongoItemReader<T> build() {
        Assert.notNull((Object)this.template, "template is required.");
        if (this.saveState) {
            Assert.hasText(this.name, "A name is required when saveState is set to true");
        }
        Assert.notNull(this.targetType, "targetType is required.");
        Assert.state(StringUtils.hasText(this.jsonQuery) || this.query != null, "A query is required");
        if (StringUtils.hasText(this.jsonQuery)) {
            Assert.notNull(this.sorts, "sorts map is required.");
        } else {
            Assert.state(this.query.getLimit() != 0, "PageSize in Query object was ignored.");
        }
        MongoItemReader<? extends T> reader = new MongoItemReader<T>();
        reader.setTemplate(this.template);
        reader.setTargetType(this.targetType);
        reader.setQuery(this.jsonQuery);
        reader.setSort(this.sorts);
        reader.setHint(this.hint);
        reader.setFields(this.fields);
        reader.setCollection(this.collection);
        reader.setParameterValues(this.parameterValues);
        reader.setQuery(this.query);
        reader.setPageSize(this.pageSize);
        reader.setName(this.name);
        reader.setSaveState(this.saveState);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        return reader;
    }
}

