/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.adapter.AbstractMethodInvokingDelegator;
import org.springframework.batch.item.adapter.DynamicMethodInvocationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.repository.CrudRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MethodInvoker;

public class RepositoryItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(RepositoryItemWriter.class);
    private CrudRepository<T, ?> repository;
    private String methodName;

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setRepository(CrudRepository<T, ?> repository) {
        this.repository = repository;
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        if (!CollectionUtils.isEmpty(items)) {
            this.doWrite(items);
        }
    }

    protected void doWrite(List<? extends T> items) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Writing to the repository with " + items.size() + " items.");
        }
        MethodInvoker invoker = this.createMethodInvoker(this.repository, this.methodName);
        for (T object : items) {
            invoker.setArguments(object);
            this.doInvoke(invoker);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.repository != null, "A CrudRepository implementation is required");
    }

    private Object doInvoke(MethodInvoker invoker) throws Exception {
        try {
            invoker.prepare();
        }
        catch (ClassNotFoundException e) {
            throw new DynamicMethodInvocationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DynamicMethodInvocationException(e);
        }
        try {
            return invoker.invoke();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw new AbstractMethodInvokingDelegator.InvocationTargetThrowableWrapper(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new DynamicMethodInvocationException(e);
        }
    }

    private MethodInvoker createMethodInvoker(Object targetObject, String targetMethod) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(targetObject);
        invoker.setTargetMethod(targetMethod);
        return invoker;
    }
}

