/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MongoItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private MongoOperations template;
    private final Object bufferKey = new Object();
    private String collection;
    private boolean delete = false;

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    protected MongoOperations getTemplate() {
        return this.template;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        if (!this.transactionActive()) {
            this.doWrite(items);
            return;
        }
        List<T> bufferedItems = this.getCurrentBuffer();
        bufferedItems.addAll(items);
    }

    protected void doWrite(List<? extends T> items) {
        block10: {
            if (CollectionUtils.isEmpty(items)) break block10;
            if (this.delete) {
                if (StringUtils.hasText(this.collection)) {
                    for (T object : items) {
                        this.template.remove(object, this.collection);
                    }
                } else {
                    for (T object : items) {
                        this.template.remove(object);
                    }
                }
            } else if (StringUtils.hasText(this.collection)) {
                for (T object : items) {
                    this.template.save(object, this.collection);
                }
            } else {
                for (T object : items) {
                    this.template.save(object);
                }
            }
        }
    }

    private boolean transactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    private List<T> getCurrentBuffer() {
        if (!TransactionSynchronizationManager.hasResource(this.bufferKey)) {
            TransactionSynchronizationManager.bindResource(this.bufferKey, new ArrayList());
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronizationAdapter(){

                @Override
                public void beforeCommit(boolean readOnly) {
                    List items = (List)TransactionSynchronizationManager.getResource(MongoItemWriter.this.bufferKey);
                    if (!CollectionUtils.isEmpty(items) && !readOnly) {
                        MongoItemWriter.this.doWrite(items);
                    }
                }

                @Override
                public void afterCompletion(int status) {
                    if (TransactionSynchronizationManager.hasResource(MongoItemWriter.this.bufferKey)) {
                        TransactionSynchronizationManager.unbindResource(MongoItemWriter.this.bufferKey);
                    }
                }
            });
        }
        return (List)TransactionSynchronizationManager.getResource(this.bufferKey);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.template != null, "A MongoOperations implementation is required.");
    }
}

