/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.SimpleChunkProvider;
import org.springframework.batch.core.step.item.SkipOverflowException;
import org.springframework.batch.core.step.skip.LimitCheckingItemSkipPolicy;
import org.springframework.batch.core.step.skip.NonSkippableReadException;
import org.springframework.batch.core.step.skip.SkipException;
import org.springframework.batch.core.step.skip.SkipListenerFailedException;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.skip.SkipPolicyFailedException;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.Classifier;

public class FaultTolerantChunkProvider<I>
extends SimpleChunkProvider<I> {
    public static final int DEFAULT_MAX_SKIPS_ON_READ = 100;
    private SkipPolicy skipPolicy = new LimitCheckingItemSkipPolicy();
    private Classifier<Throwable, Boolean> rollbackClassifier = new BinaryExceptionClassifier(true);
    private int maxSkipsOnRead = 100;

    public FaultTolerantChunkProvider(ItemReader<? extends I> itemReader, RepeatOperations repeatOperations) {
        super(itemReader, repeatOperations);
    }

    public void setMaxSkipsOnRead(int maxSkipsOnRead) {
        this.maxSkipsOnRead = maxSkipsOnRead;
    }

    public void setSkipPolicy(SkipPolicy SkipPolicy2) {
        this.skipPolicy = SkipPolicy2;
    }

    public void setRollbackClassifier(Classifier<Throwable, Boolean> rollbackClassifier) {
        this.rollbackClassifier = rollbackClassifier;
    }

    @Override
    protected I read(StepContribution contribution, Chunk<I> chunk) throws Exception {
        while (true) {
            try {
                return this.doRead();
            }
            catch (Exception e) {
                if (this.shouldSkip(this.skipPolicy, e, contribution.getStepSkipCount())) {
                    contribution.incrementReadSkipCount();
                    chunk.skip(e);
                    if (chunk.getErrors().size() >= this.maxSkipsOnRead) {
                        throw new SkipOverflowException("Too many skips on read");
                    }
                    this.logger.debug("Skipping failed input", e);
                    continue;
                }
                if (this.rollbackClassifier.classify(e).booleanValue()) {
                    throw new NonSkippableReadException("Non-skippable exception during read", e);
                }
                this.logger.debug("No-rollback for non-skippable exception (ignored)", e);
                continue;
            }
            break;
        }
    }

    @Override
    public void postProcess(StepContribution contribution, Chunk<I> chunk) {
        for (Exception e : chunk.getErrors()) {
            try {
                this.getListener().onSkipInRead(e);
            }
            catch (RuntimeException ex) {
                throw new SkipListenerFailedException("Fatal exception in SkipListener.", ex, e);
            }
        }
    }

    private boolean shouldSkip(SkipPolicy policy, Throwable e, int skipCount) {
        try {
            return policy.shouldSkip(e, skipCount);
        }
        catch (SkipException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new SkipPolicyFailedException("Fatal exception in SkipPolicy.", ex, e);
        }
    }
}

