/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.DefaultSerializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.util.Assert;

public class DefaultExecutionContextSerializer
implements ExecutionContextSerializer {
    private Serializer serializer = new DefaultSerializer();
    private Deserializer deserializer = new DefaultDeserializer();

    @Override
    public void serialize(Map<String, Object> context, OutputStream out) throws IOException {
        Assert.notNull(context);
        Assert.notNull(out);
        for (Object value : context.values()) {
            Assert.isInstanceOf(Serializable.class, value, "Value: [ " + value + "must be serializable.");
        }
        this.serializer.serialize(context, out);
    }

    @Override
    public Map<String, Object> deserialize(InputStream inputStream) throws IOException {
        return (Map)this.deserializer.deserialize(inputStream);
    }
}

