/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step.builder;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.core.jsr.step.BatchletStep;
import org.springframework.batch.core.jsr.step.item.JsrChunkProvider;
import org.springframework.batch.core.jsr.step.item.JsrFaultTolerantChunkProcessor;
import org.springframework.batch.core.step.builder.FaultTolerantStepBuilder;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.builder.StepBuilderException;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.core.step.item.ChunkProvider;
import org.springframework.batch.core.step.skip.SkipPolicy;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;

public class JsrFaultTolerantStepBuilder<I, O>
extends FaultTolerantStepBuilder<I, O> {
    private BatchPropertyContext batchPropertyContext;

    public void setBatchPropertyContext(BatchPropertyContext batchPropertyContext) {
        this.batchPropertyContext = batchPropertyContext;
    }

    public JsrFaultTolerantStepBuilder(StepBuilder parent) {
        super(parent);
    }

    @Override
    public FaultTolerantStepBuilder<I, O> faultTolerant() {
        return this;
    }

    @Override
    public TaskletStep build() {
        this.registerStepListenerAsSkipListener();
        this.registerAsStreamsAndListeners(this.getReader(), this.getProcessor(), this.getWriter());
        this.registerStepListenerAsChunkListener();
        BatchletStep step = new BatchletStep(this.getName(), this.batchPropertyContext);
        super.enhance(step);
        step.setChunkListeners(this.chunkListeners.toArray(new ChunkListener[0]));
        if (this.getTransactionAttribute() != null) {
            step.setTransactionAttribute(this.getTransactionAttribute());
        }
        if (this.getStepOperations() == null) {
            this.stepOperations(new RepeatTemplate());
            if (this.getTaskExecutor() != null) {
                TaskExecutorRepeatTemplate repeatTemplate = new TaskExecutorRepeatTemplate();
                repeatTemplate.setTaskExecutor(this.getTaskExecutor());
                repeatTemplate.setThrottleLimit(this.getThrottleLimit());
                this.stepOperations(repeatTemplate);
            }
            ((RepeatTemplate)this.getStepOperations()).setExceptionHandler(this.getExceptionHandler());
        }
        step.setStepOperations(this.getStepOperations());
        step.setTasklet(this.createTasklet());
        step.setStreams(this.getStreams().toArray(new ItemStream[0]));
        try {
            step.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new StepBuilderException(e);
        }
        return step;
    }

    @Override
    protected ChunkProvider<I> createChunkProvider() {
        return new JsrChunkProvider();
    }

    @Override
    protected ChunkProcessor<I> createChunkProcessor() {
        SkipPolicy skipPolicy = this.getFatalExceptionAwareProxy(this.createSkipPolicy());
        JsrFaultTolerantChunkProcessor chunkProcessor = new JsrFaultTolerantChunkProcessor(this.getReader(), this.getProcessor(), this.getWriter(), this.createChunkOperations(), this.createRetryOperations());
        chunkProcessor.setSkipPolicy(skipPolicy);
        chunkProcessor.setRollbackClassifier(this.getRollbackClassifier());
        this.detectStreamInReader();
        chunkProcessor.setChunkMonitor(this.getChunkMonitor());
        chunkProcessor.setListeners(this.getChunkListeners());
        return chunkProcessor;
    }

    private List<StepListener> getChunkListeners() {
        ArrayList<StepListener> listeners = new ArrayList<StepListener>();
        listeners.addAll(this.getItemListeners());
        listeners.addAll(this.getSkipListeners());
        listeners.addAll(this.getJsrRetryListeners());
        return listeners;
    }
}

