/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.step.builder;

import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.jsr.configuration.support.BatchPropertyContext;
import org.springframework.batch.core.jsr.step.BatchletStep;
import org.springframework.batch.core.step.builder.StepBuilderException;
import org.springframework.batch.core.step.builder.StepBuilderHelper;
import org.springframework.batch.core.step.builder.TaskletStepBuilder;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.batch.repeat.support.TaskExecutorRepeatTemplate;

public class JsrBatchletStepBuilder
extends TaskletStepBuilder {
    private BatchPropertyContext batchPropertyContext;

    public void setBatchPropertyContext(BatchPropertyContext context) {
        this.batchPropertyContext = context;
    }

    public JsrBatchletStepBuilder(StepBuilderHelper<? extends StepBuilderHelper<?>> parent) {
        super(parent);
    }

    @Override
    public TaskletStep build() {
        this.registerStepListenerAsChunkListener();
        BatchletStep step = new BatchletStep(this.getName(), this.batchPropertyContext);
        super.enhance(step);
        step.setChunkListeners(this.chunkListeners.toArray(new ChunkListener[0]));
        if (this.getTransactionAttribute() != null) {
            step.setTransactionAttribute(this.getTransactionAttribute());
        }
        if (this.getStepOperations() == null) {
            this.stepOperations(new RepeatTemplate());
            if (this.getTaskExecutor() != null) {
                TaskExecutorRepeatTemplate repeatTemplate = new TaskExecutorRepeatTemplate();
                repeatTemplate.setTaskExecutor(this.getTaskExecutor());
                repeatTemplate.setThrottleLimit(this.getThrottleLimit());
                this.stepOperations(repeatTemplate);
            }
            ((RepeatTemplate)this.getStepOperations()).setExceptionHandler(this.getExceptionHandler());
        }
        step.setStepOperations(this.getStepOperations());
        step.setTasklet(this.createTasklet());
        step.setStreams(this.getStreams().toArray(new ItemStream[0]));
        try {
            step.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new StepBuilderException(e);
        }
        return step;
    }
}

