/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import javax.batch.api.Decider;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.jsr.step.DecisionStep;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DecisionStepFactoryBean
implements FactoryBean<Step>,
InitializingBean {
    private Decider jsrDecider;
    private String name;
    private JobRepository jobRepository;

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setDecider(Decider decider) {
        this.jsrDecider = decider;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Step getObject() throws Exception {
        DecisionStep decisionStep = new DecisionStep(this.jsrDecider);
        decisionStep.setName(this.name);
        decisionStep.setJobRepository(this.jobRepository);
        decisionStep.setAllowStartIfComplete(true);
        return decisionStep;
    }

    @Override
    public Class<?> getObjectType() {
        return DecisionStep.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.isTrue(this.jsrDecider != null, "A decider implementation is required");
        Assert.notNull((Object)this.name, "A name is required for a decision state");
    }
}

