/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class BatchParser
extends AbstractBeanDefinitionParser {
    private static final Log logger = LogFactory.getLog(BatchParser.class);

    @Override
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    @Override
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        this.parseRefElements(element, registry);
        return null;
    }

    private void parseRefElements(Element element, BeanDefinitionRegistry registry) {
        List<Element> beanElements = DomUtils.getChildElementsByTagName(element, "ref");
        if (beanElements.size() > 0) {
            for (Element curElement : beanElements) {
                AbstractBeanDefinition beanDefintion = BeanDefinitionBuilder.genericBeanDefinition(curElement.getAttribute("class")).getBeanDefinition();
                beanDefintion.setScope("step");
                String beanName = curElement.getAttribute("id");
                if (!registry.containsBeanDefinition(beanName)) {
                    registry.registerBeanDefinition(beanName, beanDefintion);
                    continue;
                }
                logger.info("Ignoring batch.xml bean defintion for " + beanName + " because another bean of the same name has been registered");
            }
        }
    }
}

