/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.context.JobContext;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.util.Assert;

public class JsrJobContext
implements JobContext {
    private Object transientUserData;
    private Properties properties;
    private JobExecution jobExecution;
    private AtomicBoolean exitStatusSet = new AtomicBoolean();

    public void setJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, "A JobExecution is required");
        this.jobExecution = jobExecution;
    }

    public void setProperties(Properties properties) {
        this.properties = properties != null ? properties : new Properties();
    }

    @Override
    public String getJobName() {
        return this.jobExecution.getJobInstance().getJobName();
    }

    @Override
    public Object getTransientUserData() {
        return this.transientUserData;
    }

    @Override
    public void setTransientUserData(Object data) {
        this.transientUserData = data;
    }

    @Override
    public long getInstanceId() {
        return this.jobExecution.getJobInstance().getId();
    }

    @Override
    public long getExecutionId() {
        return this.jobExecution.getId();
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.jobExecution.getStatus().getBatchStatus();
    }

    @Override
    public String getExitStatus() {
        return this.exitStatusSet.get() ? this.jobExecution.getExitStatus().getExitCode() : null;
    }

    @Override
    public void setExitStatus(String status) {
        this.jobExecution.setExitStatus(new ExitStatus(status));
        this.exitStatusSet.set(true);
    }
}

