/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.batch.core.configuration.support.AbstractApplicationContextFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GenericApplicationContextFactory
extends AbstractApplicationContextFactory {
    public GenericApplicationContextFactory(Object ... resources) {
        super(resources);
    }

    @Override
    protected ConfigurableApplicationContext createApplicationContext(ConfigurableApplicationContext parent, Object ... resources) {
        GenericApplicationContext context;
        if (this.allObjectsOfType(resources, Resource.class)) {
            context = new ResourceXmlApplicationContext(parent, resources);
        } else if (this.allObjectsOfType(resources, Class.class)) {
            context = new ResourceAnnotationApplicationContext(parent, resources);
        } else if (this.allObjectsOfType(resources, String.class)) {
            context = new ResourceAnnotationApplicationContext(parent, resources);
        } else {
            ArrayList types = new ArrayList();
            for (Object resource : resources) {
                types.add(resource.getClass());
            }
            throw new IllegalArgumentException("No application context could be created for resource types: " + Arrays.toString(types.toArray()));
        }
        return context;
    }

    private boolean allObjectsOfType(Object[] objects, Class<?> type) {
        for (Object object : objects) {
            if (type.isInstance(object)) continue;
            return false;
        }
        return true;
    }

    private final class ResourceAnnotationApplicationContext
    extends AnnotationConfigApplicationContext {
        private final ApplicationContextHelper helper;

        public ResourceAnnotationApplicationContext(ConfigurableApplicationContext parent, Object ... resources) {
            this.helper = new ApplicationContextHelper(parent, (GenericApplicationContext)this, resources){

                @Override
                protected String generateId(Object ... configs) {
                    if (GenericApplicationContextFactory.this.allObjectsOfType(configs, Class.class)) {
                        Class[] types = (Class[])Arrays.copyOfRange(configs, 0, configs.length, Class[].class);
                        ArrayList<String> names = new ArrayList<String>();
                        for (Class type : types) {
                            names.add(type.getName());
                        }
                        return StringUtils.collectionToCommaDelimitedString(names);
                    }
                    return Arrays.toString(configs);
                }

                @Override
                protected void loadConfiguration(Object ... configs) {
                    if (GenericApplicationContextFactory.this.allObjectsOfType(configs, Class.class)) {
                        Class[] types = (Class[])Arrays.copyOfRange(configs, 0, configs.length, Class[].class);
                        ResourceAnnotationApplicationContext.this.register(types);
                    } else {
                        String[] pkgs = (String[])Arrays.copyOfRange(configs, 0, configs.length, String[].class);
                        ResourceAnnotationApplicationContext.this.scan(pkgs);
                    }
                }
            };
            this.refresh();
        }

        @Override
        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            super.prepareBeanFactory(beanFactory);
            this.helper.prepareBeanFactory(beanFactory);
        }

        @Override
        public String toString() {
            return "ResourceAnnotationApplicationContext:" + this.getId();
        }
    }

    private final class ResourceXmlApplicationContext
    extends GenericXmlApplicationContext {
        private final ApplicationContextHelper helper;

        public ResourceXmlApplicationContext(ConfigurableApplicationContext parent, Object ... resources) {
            this.helper = new ApplicationContextHelper(parent, (GenericApplicationContext)this, resources){

                @Override
                protected String generateId(Object ... configs) {
                    Object[] resources = (Resource[])Arrays.copyOfRange(configs, 0, configs.length, Resource[].class);
                    try {
                        ArrayList<String> uris = new ArrayList<String>();
                        for (Object resource : resources) {
                            uris.add(resource.getURI().toString());
                        }
                        return StringUtils.collectionToCommaDelimitedString(uris);
                    }
                    catch (IOException e) {
                        return Arrays.toString(resources);
                    }
                }

                @Override
                protected void loadConfiguration(Object ... configs) {
                    Resource[] resources = (Resource[])Arrays.copyOfRange(configs, 0, configs.length, Resource[].class);
                    ResourceXmlApplicationContext.this.load(resources);
                }
            };
            this.refresh();
        }

        @Override
        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            super.prepareBeanFactory(beanFactory);
            this.helper.prepareBeanFactory(beanFactory);
        }

        @Override
        public String toString() {
            return "ResourceXmlApplicationContext:" + this.getId();
        }
    }

    private abstract class ApplicationContextHelper {
        private final DefaultListableBeanFactory parentBeanFactory;
        private final ConfigurableApplicationContext parent;

        public ApplicationContextHelper(ConfigurableApplicationContext parent, GenericApplicationContext context, Object ... config) {
            this.parent = parent;
            if (parent != null) {
                Assert.isTrue(parent.getBeanFactory() instanceof DefaultListableBeanFactory, "The parent application context must have a bean factory of type DefaultListableBeanFactory");
                this.parentBeanFactory = (DefaultListableBeanFactory)parent.getBeanFactory();
            } else {
                this.parentBeanFactory = null;
            }
            context.setParent(parent);
            context.setId(this.generateId(config));
            this.loadConfiguration(config);
            GenericApplicationContextFactory.this.prepareContext(parent, context);
        }

        protected abstract String generateId(Object ... var1);

        protected abstract void loadConfiguration(Object ... var1);

        protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            if (this.parentBeanFactory != null) {
                GenericApplicationContextFactory.this.prepareBeanFactory(this.parentBeanFactory, beanFactory);
                for (Class<? extends BeanFactoryPostProcessor> cls : GenericApplicationContextFactory.this.getBeanFactoryPostProcessorClasses()) {
                    for (String name : this.parent.getBeanNamesForType(cls)) {
                        beanFactory.registerSingleton(name, this.parent.getBean(name));
                    }
                }
            }
        }
    }
}

