/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.wildcard;

import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CReferencePropertyInfo;
import com.sun.tools.xjc.model.Model;
import com.sun.xml.bind.v2.model.core.WildcardMode;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.wildcard.Customizations;
import org.jvnet.jaxb2_commons.util.CustomizationUtils;
import org.xml.sax.ErrorHandler;

public class WildcardPlugin
extends AbstractParameterizablePlugin {
    @Override
    public String getOptionName() {
        return "Xwildcard";
    }

    @Override
    public String getUsage() {
        return "Allows specifying the wildcard mode in wildcard properties.";
    }

    @Override
    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        boolean laxModel = CustomizationUtils.containsCustomization(model, Customizations.LAX_ELEMENT_NAME);
        boolean skipModel = CustomizationUtils.containsCustomization(model, Customizations.SKIP_ELEMENT_NAME);
        boolean strictModel = CustomizationUtils.containsCustomization(model, Customizations.STRICT_ELEMENT_NAME);
        for (CClassInfo classInfo : model.beans().values()) {
            boolean laxClassInfo = CustomizationUtils.containsCustomization(classInfo, Customizations.LAX_ELEMENT_NAME);
            boolean skipClassInfo = CustomizationUtils.containsCustomization(classInfo, Customizations.SKIP_ELEMENT_NAME);
            boolean strictClassInfo = CustomizationUtils.containsCustomization(classInfo, Customizations.STRICT_ELEMENT_NAME);
            for (CPropertyInfo propertyInfo : classInfo.getProperties()) {
                if (!(propertyInfo instanceof CReferencePropertyInfo)) continue;
                CReferencePropertyInfo referencePropertyInfo = (CReferencePropertyInfo)propertyInfo;
                boolean laxPropertyInfo = CustomizationUtils.containsCustomization(referencePropertyInfo, Customizations.LAX_ELEMENT_NAME);
                boolean skipPropertyInfo = CustomizationUtils.containsCustomization(referencePropertyInfo, Customizations.SKIP_ELEMENT_NAME);
                boolean strictPropertyInfo = CustomizationUtils.containsCustomization(referencePropertyInfo, Customizations.STRICT_ELEMENT_NAME);
                if (laxModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictModel) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (laxClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                } else if (skipClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                } else if (strictClassInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.STRICT);
                }
                if (laxPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.LAX);
                    continue;
                }
                if (skipPropertyInfo) {
                    referencePropertyInfo.setWildcard(WildcardMode.SKIP);
                    continue;
                }
                if (!strictPropertyInfo) continue;
                referencePropertyInfo.setWildcard(WildcardMode.STRICT);
            }
        }
    }

    @Override
    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.LAX_ELEMENT_NAME, Customizations.SKIP_ELEMENT_NAME, Customizations.STRICT_ELEMENT_NAME);
    }
}

