/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.simplehashcode;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.Collection;
import java.util.ListIterator;
import org.apache.commons.lang3.Validate;
import org.jvnet.jaxb2_commons.plugin.codegenerator.Arguments;

public class HashCodeArguments
implements Arguments<HashCodeArguments> {
    private final JCodeModel codeModel;
    private final JVar currentHashCode;
    private final int multiplier;
    private final JVar value;
    private final JExpression hasSetValue;

    public HashCodeArguments(JCodeModel codeModel, JVar currentHashCode, int multiplier, JVar value, JExpression hasSetValue) {
        this.codeModel = Validate.notNull(codeModel);
        this.currentHashCode = Validate.notNull(currentHashCode);
        this.multiplier = multiplier;
        this.value = Validate.notNull(value);
        this.hasSetValue = Validate.notNull(hasSetValue);
    }

    private JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public JVar currentHashCode() {
        return this.currentHashCode;
    }

    public int multiplier() {
        return this.multiplier;
    }

    public JVar value() {
        return this.value;
    }

    public JExpression hasSetValue() {
        return this.hasSetValue;
    }

    private HashCodeArguments spawn(JVar value, JExpression hasSetValue) {
        return new HashCodeArguments(this.getCodeModel(), this.currentHashCode(), this.multiplier(), value, hasSetValue);
    }

    @Override
    public HashCodeArguments property(JBlock block, String propertyName, String propertyMethod, JType declarablePropertyType, JType propertyType, Collection<JType> possiblePropertyTypes) {
        block.assign(this.currentHashCode(), this.currentHashCode().mul(JExpr.lit(this.multiplier())));
        JVar propertyValue = block.decl(8, declarablePropertyType, this.value().name() + propertyName, this.value().invoke(propertyMethod));
        boolean isAlwaysSet = propertyType.isPrimitive();
        JExpression propertyHasSetValue = isAlwaysSet ? JExpr.TRUE : propertyValue.ne(JExpr._null());
        return this.spawn(propertyValue, propertyHasSetValue);
    }

    @Override
    public HashCodeArguments iterator(JBlock block, JType elementType) {
        JVar listIterator = block.decl(8, this.getCodeModel().ref(ListIterator.class).narrow(elementType), this.value().name() + "ListIterator", this.value().invoke("listIterator"));
        return this.spawn(listIterator, JExpr.TRUE);
    }

    @Override
    public HashCodeArguments element(JBlock subBlock, JType elementType) {
        JVar elementValue = subBlock.decl(8, elementType, this.value().name() + "Element", this.value().invoke("next"));
        boolean isElementAlwaysSet = elementType.isPrimitive();
        JExpression elementHasSetValue = isElementAlwaysSet ? JExpr.TRUE : elementValue.ne(JExpr._null());
        return this.spawn(elementValue, elementHasSetValue);
    }

    @Override
    public JExpression _instanceof(JType type) {
        return this.value()._instanceof(type);
    }

    @Override
    public HashCodeArguments cast(String suffix, JBlock block, JType jaxbElementType, boolean suppressWarnings) {
        JVar castedValue = block.decl(8, jaxbElementType, this.value().name() + suffix, JExpr.cast(jaxbElementType, this.value()));
        if (suppressWarnings) {
            castedValue.annotate(SuppressWarnings.class).param("value", "unchecked");
        }
        return this.spawn(castedValue, JExpr.TRUE);
    }

    @Override
    public JBlock ifHasSetValue(JBlock block, boolean isAlwaysSet, boolean checkForNullRequired) {
        if (isAlwaysSet || !checkForNullRequired) {
            return block;
        }
        return block._if(this.hasSetValue())._then();
    }

    @Override
    public JBlock _while(JBlock block) {
        JBlock subBlock = block._while(this.value().invoke("hasNext")).body();
        subBlock.assign(this.currentHashCode(), this.currentHashCode().mul(JExpr.lit(this.multiplier())));
        return subBlock;
    }
}

