/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.model;

import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.Ring;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.xjc.generator.MModelOutlineGenerator;
import org.jvnet.jaxb2_commons.xjc.generator.concrete.ModelOutlineGeneratorFactory;
import org.jvnet.jaxb2_commons.xjc.model.concrete.XJCCMInfoFactory;
import org.jvnet.jaxb2_commons.xjc.outline.MModelOutline;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.xml.sax.ErrorHandler;

public abstract class AbstractModelPlugin
extends AbstractParameterizablePlugin {
    private MModelInfo<NType, NClass> modelInfo;

    protected MModelInfo<NType, NClass> getModel(Model model) {
        try {
            MModelInfo modelInfo = Ring.get(MModelInfo.class);
            return modelInfo;
        }
        catch (Throwable t) {
            MModelInfo<NType, NClass> mmodel = new XJCCMInfoFactory(model).createModel();
            Ring.add(MModelInfo.class, mmodel);
            return mmodel;
        }
    }

    protected MModelOutline getModelOutline(MModelInfo<NType, NClass> modelInfo, Outline outline, Options options) {
        try {
            MModelOutline modelOutline = Ring.get(MModelOutline.class);
            return modelOutline;
        }
        catch (Throwable t) {
            if (modelInfo.getOrigin() instanceof ModelOutlineGeneratorFactory) {
                MModelOutlineGenerator generator = (MModelOutlineGenerator)((ModelOutlineGeneratorFactory)modelInfo.getOrigin()).createGenerator(outline);
                MModelOutline modelOutline = generator.generate(modelInfo);
                Ring.add(MModelOutline.class, modelOutline);
                return modelOutline;
            }
            throw new AssertionError((Object)"Model is expected to be generateable");
        }
    }

    @Override
    public void postProcessModel(Model model, ErrorHandler errorHandler) {
        this.modelInfo = this.getModel(model);
        this.postProcessModel(model, this.modelInfo, errorHandler);
    }

    protected void postProcessModel(Model model, MModelInfo<NType, NClass> modelInfo, ErrorHandler errorHandler) {
    }

    @Override
    protected boolean run(Outline outline, Options options) throws Exception {
        if (!(this.modelInfo.getOrigin() instanceof ModelOutlineGeneratorFactory)) {
            throw new AssertionError((Object)"Model is expected to be generateable");
        }
        MModelOutlineGenerator generator = (MModelOutlineGenerator)((ModelOutlineGeneratorFactory)this.modelInfo.getOrigin()).createGenerator(outline);
        MModelOutline modelOutline = generator.generate(this.modelInfo);
        Ring.add(MModelOutline.class, modelOutline);
        return true;
    }
}

