/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.mergeable;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.JAXBMergeStrategy;
import org.jvnet.jaxb2_commons.lang.MergeFrom2;
import org.jvnet.jaxb2_commons.lang.MergeStrategy2;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.CustomizedIgnoring;
import org.jvnet.jaxb2_commons.plugin.Ignoring;
import org.jvnet.jaxb2_commons.plugin.mergeable.Customizations;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.jvnet.jaxb2_commons.plugin.util.StrategyClassUtils;
import org.jvnet.jaxb2_commons.util.ClassUtils;
import org.jvnet.jaxb2_commons.util.FieldAccessorFactory;
import org.jvnet.jaxb2_commons.util.PropertyFieldAccessorFactory;
import org.jvnet.jaxb2_commons.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;

public class MergeablePlugin
extends AbstractParameterizablePlugin {
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String mergeStrategyClass = JAXBMergeStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.jaxb2_commons.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.jaxb2_commons.plugin.Customizations.GENERATED_ELEMENT_NAME);

    @Override
    public String getOptionName() {
        return "Xmergeable";
    }

    @Override
    public String getUsage() {
        return "TBD";
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public void setMergeStrategyClass(String mergeStrategyClass) {
        this.mergeStrategyClass = mergeStrategyClass;
    }

    public String getMergeStrategyClass() {
        return this.mergeStrategyClass;
    }

    public JExpression createMergeStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, MergeStrategy2.class, this.getMergeStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    @Override
    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(Customizations.IGNORED_ELEMENT_NAME, org.jvnet.jaxb2_commons.plugin.Customizations.IGNORED_ELEMENT_NAME, org.jvnet.jaxb2_commons.plugin.Customizations.GENERATED_ELEMENT_NAME);
    }

    @Override
    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        ClassUtils._implements(theClass, theClass.owner().ref(MergeFrom2.class));
        JMethod mergeFrom$mergeFrom0 = this.generateMergeFrom$mergeFrom0(classOutline, theClass);
        JMethod mergeFrom$mergeFrom = this.generateMergeFrom$mergeFrom(classOutline, theClass);
        if (!classOutline.target.isAbstract()) {
            JMethod jMethod = this.generateMergeFrom$createNewInstance(classOutline, theClass);
        }
    }

    protected JMethod generateMergeFrom$mergeFrom0(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod mergeFrom$mergeFrom = theClass.method(1, codeModel.VOID, "mergeFrom");
        JVar left = mergeFrom$mergeFrom.param(Object.class, "left");
        JVar right = mergeFrom$mergeFrom.param(Object.class, "right");
        JBlock body = mergeFrom$mergeFrom.body();
        JVar mergeStrategy = body.decl(8, codeModel.ref(MergeStrategy2.class), "strategy", this.createMergeStrategy(codeModel));
        body.invoke("mergeFrom").arg(JExpr._null()).arg(JExpr._null()).arg(left).arg(right).arg(mergeStrategy);
        return mergeFrom$mergeFrom;
    }

    protected JMethod generateMergeFrom$mergeFrom(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        JCodeModel codeModel = theClass.owner();
        JMethod mergeFrom = theClass.method(1, codeModel.VOID, "mergeFrom");
        JVar leftLocator = mergeFrom.param(ObjectLocator.class, "leftLocator");
        JVar rightLocator = mergeFrom.param(ObjectLocator.class, "rightLocator");
        JVar left = mergeFrom.param(Object.class, "left");
        JVar right = mergeFrom.param(Object.class, "right");
        JVar mergeStrategy = mergeFrom.param(MergeStrategy2.class, "strategy");
        JBlock methodBody = mergeFrom.body();
        Boolean superClassImplementsMergeFrom = StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), MergeFrom2.class);
        if (superClassImplementsMergeFrom != null && superClassImplementsMergeFrom.booleanValue()) {
            methodBody.invoke(JExpr._super(), "mergeFrom").arg(leftLocator).arg(rightLocator).arg(left).arg(right).arg(mergeStrategy);
        }
        if ((declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())).length > 0) {
            JBlock body = methodBody._if(right._instanceof(theClass))._then();
            JVar target = body.decl(8, theClass, "target", JExpr._this());
            JVar leftObject = body.decl(8, theClass, "leftObject", JExpr.cast(theClass, left));
            JVar rightObject = body.decl(8, theClass, "rightObject", JExpr.cast(theClass, right));
            for (FieldOutline fieldOutline : declaredFields) {
                FieldAccessorEx leftFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, leftObject);
                FieldAccessorEx rightFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, rightObject);
                if (leftFieldAccessor.isConstant() || rightFieldAccessor.isConstant()) continue;
                JBlock block = body.block();
                JExpression leftFieldHasSetValue = leftFieldAccessor.isAlwaysSet() || leftFieldAccessor.hasSetValue() == null ? JExpr.TRUE : leftFieldAccessor.hasSetValue();
                JExpression rightFieldHasSetValue = rightFieldAccessor.isAlwaysSet() || rightFieldAccessor.hasSetValue() == null ? JExpr.TRUE : rightFieldAccessor.hasSetValue();
                JVar shouldBeSet = block.decl(codeModel.ref(Boolean.class), fieldOutline.getPropertyInfo().getName(false) + "ShouldBeMergedAndSet", mergeStrategy.invoke("shouldBeMergedAndSet").arg(leftLocator).arg(rightLocator).arg(leftFieldHasSetValue).arg(rightFieldHasSetValue));
                JConditional ifShouldBeSetConditional = block._if(JOp.eq(shouldBeSet, codeModel.ref(Boolean.class).staticRef("TRUE")));
                JBlock ifShouldBeSetBlock = ifShouldBeSetConditional._then();
                JConditional ifShouldNotBeSetConditional = ifShouldBeSetConditional._elseif(JOp.eq(shouldBeSet, codeModel.ref(Boolean.class).staticRef("FALSE")));
                JBlock ifShouldBeUnsetBlock = ifShouldNotBeSetConditional._then();
                JVar leftField = ifShouldBeSetBlock.decl(leftFieldAccessor.getType(), "lhs" + fieldOutline.getPropertyInfo().getName(true));
                leftFieldAccessor.toRawValue(ifShouldBeSetBlock, leftField);
                JVar rightField = ifShouldBeSetBlock.decl(rightFieldAccessor.getType(), "rhs" + fieldOutline.getPropertyInfo().getName(true));
                rightFieldAccessor.toRawValue(ifShouldBeSetBlock, rightField);
                JInvocation leftFieldLocator = codeModel.ref(LocatorUtils.class).staticInvoke("property").arg(leftLocator).arg(fieldOutline.getPropertyInfo().getName(false)).arg(leftField);
                JInvocation rightFieldLocator = codeModel.ref(LocatorUtils.class).staticInvoke("property").arg(rightLocator).arg(fieldOutline.getPropertyInfo().getName(false)).arg(rightField);
                FieldAccessorEx targetFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, target);
                JCast mergedValue = JExpr.cast(targetFieldAccessor.getType(), mergeStrategy.invoke("merge").arg(leftFieldLocator).arg(rightFieldLocator).arg(leftField).arg(rightField).arg(leftFieldHasSetValue).arg(rightFieldHasSetValue));
                JVar merged = ifShouldBeSetBlock.decl(rightFieldAccessor.getType(), "merged" + fieldOutline.getPropertyInfo().getName(true), mergedValue);
                targetFieldAccessor.fromRawValue(ifShouldBeSetBlock, "unique" + fieldOutline.getPropertyInfo().getName(true), merged);
                targetFieldAccessor.unsetValues(ifShouldBeUnsetBlock);
            }
        }
        return mergeFrom;
    }

    protected JMethod generateMergeFrom$createNewInstance(ClassOutline classOutline, JDefinedClass theClass) {
        JMethod existingMethod = theClass.getMethod("createNewInstance", new JType[0]);
        if (existingMethod == null) {
            JMethod newMethod = theClass.method(1, theClass.owner().ref(Object.class), "createNewInstance");
            JBlock body = newMethod.body();
            body._return(JExpr._new(theClass));
            return newMethod;
        }
        return existingMethod;
    }
}

