/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.copyable;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.CopyStrategy2;
import org.jvnet.jaxb2_commons.lang.CopyTo2;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;
import org.jvnet.jaxb2_commons.plugin.AbstractParameterizablePlugin;
import org.jvnet.jaxb2_commons.plugin.Customizations;
import org.jvnet.jaxb2_commons.plugin.CustomizedIgnoring;
import org.jvnet.jaxb2_commons.plugin.Ignoring;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.jvnet.jaxb2_commons.plugin.util.StrategyClassUtils;
import org.jvnet.jaxb2_commons.util.ClassUtils;
import org.jvnet.jaxb2_commons.util.FieldAccessorFactory;
import org.jvnet.jaxb2_commons.util.PropertyFieldAccessorFactory;
import org.jvnet.jaxb2_commons.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;

public class CopyablePlugin
extends AbstractParameterizablePlugin {
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String copyStrategyClass = JAXBCopyStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.jaxb2_commons.plugin.copyable.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    @Override
    public String getOptionName() {
        return "Xcopyable";
    }

    @Override
    public String getUsage() {
        return "TBD";
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public void setCopyStrategyClass(String copyStrategy) {
        this.copyStrategyClass = copyStrategy;
    }

    public String getCopyStrategyClass() {
        return this.copyStrategyClass;
    }

    public JExpression createCopyStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, CopyStrategy2.class, this.getCopyStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    @Override
    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.jaxb2_commons.plugin.copyable.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    @Override
    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            if (this.getIgnoring().isIgnored(classOutline)) continue;
            this.processClassOutline(classOutline);
        }
        return true;
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        ClassUtils._implements(theClass, theClass.owner().ref(Cloneable.class));
        JMethod object$clone = this.generateObject$clone(classOutline, theClass);
        ClassUtils._implements(theClass, theClass.owner().ref(CopyTo2.class));
        JMethod copyTo$copyTo = this.generateCopyTo$copyTo(classOutline, theClass);
        JMethod copyTo$copyTo1 = this.generateCopyTo$copyTo1(classOutline, theClass);
        if (!classOutline.target.isAbstract()) {
            JMethod jMethod = this.generateCopyTo$createNewInstance(classOutline, theClass);
        }
    }

    protected JMethod generateCopyTo$createNewInstance(ClassOutline classOutline, JDefinedClass theClass) {
        JMethod existingMethod = theClass.getMethod("createNewInstance", new JType[0]);
        if (existingMethod == null) {
            JMethod newMethod = theClass.method(1, theClass.owner().ref(Object.class), "createNewInstance");
            JBlock body = newMethod.body();
            body._return(JExpr._new(theClass));
            return newMethod;
        }
        return existingMethod;
    }

    protected JMethod generateObject$clone(ClassOutline classOutline, JDefinedClass theClass) {
        JMethod clone = theClass.method(1, theClass.owner().ref(Object.class), "clone");
        JBlock body = clone.body();
        body._return(JExpr.invoke("copyTo").arg(JExpr.invoke("createNewInstance")));
        return clone;
    }

    protected JMethod generateCopyTo$copyTo(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod copyTo$copyTo = theClass.method(1, codeModel.ref(Object.class), "copyTo");
        JVar target = copyTo$copyTo.param(Object.class, "target");
        JBlock body = copyTo$copyTo.body();
        JVar copyStrategy = body.decl(8, codeModel.ref(CopyStrategy2.class), "strategy", this.createCopyStrategy(codeModel));
        body._return(JExpr.invoke("copyTo").arg(JExpr._null()).arg(target).arg(copyStrategy));
        return copyTo$copyTo;
    }

    protected JMethod generateCopyTo$copyTo1(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        JVar draftCopy;
        JCodeModel codeModel = theClass.owner();
        ClassUtils._implements(theClass, codeModel.ref(CopyTo2.class));
        JMethod copyTo = theClass.method(1, codeModel.ref(Object.class), "copyTo");
        JVar locator = copyTo.param(ObjectLocator.class, "locator");
        JVar target = copyTo.param(Object.class, "target");
        JVar copyStrategy = copyTo.param(CopyStrategy2.class, "strategy");
        JBlock body = copyTo.body();
        if (!classOutline.target.isAbstract()) {
            draftCopy = body.decl(8, codeModel.ref(Object.class), "draftCopy", JOp.cond(JOp.eq(target, JExpr._null()), JExpr.invoke("createNewInstance"), target));
        } else {
            body._if(JExpr._null().eq(target))._then()._throw(JExpr._new(codeModel.ref(IllegalArgumentException.class)).arg("Target argument must not be null for abstract copyable classes."));
            draftCopy = target;
        }
        Boolean superClassImplementsCopyTo = StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), CopyTo2.class);
        if (superClassImplementsCopyTo != null && superClassImplementsCopyTo.booleanValue()) {
            body.invoke(JExpr._super(), "copyTo").arg(locator).arg(draftCopy).arg(copyStrategy);
        }
        if ((declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())).length > 0) {
            JBlock bl = body._if(draftCopy._instanceof(theClass))._then();
            JVar copy = bl.decl(8, theClass, "copy", JExpr.cast(theClass, draftCopy));
            for (FieldOutline fieldOutline : declaredFields) {
                FieldAccessorEx sourceFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
                FieldAccessorEx copyFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, copy);
                if (sourceFieldAccessor.isConstant()) continue;
                JBlock block = bl.block();
                JExpression valueIsSet = sourceFieldAccessor.isAlwaysSet() || sourceFieldAccessor.hasSetValue() == null ? JExpr.TRUE : sourceFieldAccessor.hasSetValue();
                JVar shouldBeCopied = block.decl(codeModel.ref(Boolean.class), fieldOutline.getPropertyInfo().getName(false) + "ShouldBeCopiedAndSet", copyStrategy.invoke("shouldBeCopiedAndSet").arg(locator).arg(valueIsSet));
                JConditional ifShouldBeSetConditional = block._if(JOp.eq(shouldBeCopied, codeModel.ref(Boolean.class).staticRef("TRUE")));
                JBlock ifShouldBeSetBlock = ifShouldBeSetConditional._then();
                JConditional ifShouldNotBeSetConditional = ifShouldBeSetConditional._elseif(JOp.eq(shouldBeCopied, codeModel.ref(Boolean.class).staticRef("FALSE")));
                JBlock ifShouldBeUnsetBlock = ifShouldNotBeSetConditional._then();
                JType copyFieldType = sourceFieldAccessor.getType();
                JVar sourceField = ifShouldBeSetBlock.decl(copyFieldType, "source" + fieldOutline.getPropertyInfo().getName(true));
                sourceFieldAccessor.toRawValue(ifShouldBeSetBlock, sourceField);
                JInvocation builtCopy = JExpr.invoke((JExpression)copyStrategy, "copy").arg(codeModel.ref(LocatorUtils.class).staticInvoke("property").arg(locator).arg(fieldOutline.getPropertyInfo().getName(false)).arg(sourceField)).arg(sourceField).arg(valueIsSet);
                JVar copyField = ifShouldBeSetBlock.decl(copyFieldType, "copy" + fieldOutline.getPropertyInfo().getName(true), copyFieldType.isPrimitive() ? builtCopy : JExpr.cast(copyFieldType, builtCopy));
                if (copyFieldType instanceof JClass && ((JClass)copyFieldType).isParameterized()) {
                    copyField.annotate(SuppressWarnings.class).param("value", "unchecked");
                }
                copyFieldAccessor.fromRawValue(ifShouldBeSetBlock, "unique" + fieldOutline.getPropertyInfo().getName(true), copyField);
                copyFieldAccessor.unsetValues(ifShouldBeUnsetBlock);
            }
        }
        body._return(draftCopy);
        return copyTo;
    }
}

